package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description:还款消息状态枚举
 * @author: hzz
 * @createDate: 2023/12/13
 */
@Getter
@AllArgsConstructor
public enum RepaymentMessageStateEnum {
    UN_CONFIRM(0,"待确认"),
    CONFIRM(1,"已确认");
    /**
     * 编码
     */
    private Integer code;
    /**
     * 名称，描述
     */
    private String remark;

    public static RepaymentMessageStateEnum getByCode(Integer code) {
        RepaymentMessageStateEnum anEnum = null;
        for (RepaymentMessageStateEnum type : RepaymentMessageStateEnum.values()) {
            if (type.getCode() == code) {
                anEnum = type;
                break;
            }
        }
        return anEnum;
    }
}
