package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.yeejoin.amos.boot.module.hygf.api.entity.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @description:
 * @author: tw
 * @createDate: 2024/1/12
 */
@Data
@ApiModel(value = "PowerStationEngineeringInfoAllDto",description = "施工工程信息")
public class PowerStationEngineeringInfoAllDto {


    //并网验收审核记录
    @ApiModelProperty(value = "并网验收审核记录")
    LoggerDto loggerDto;
    //验收审核记录
    @ApiModelProperty(value = "验收审核记录")
    LoggerDto loggerYsDto;

    //自审信息
    @ApiModelProperty(value = "自审信息")
    ConstructionRecords constructionRecords;

    @ApiModelProperty(value = "并网操作日志")
    ConstructionGirdRecords constructionGirdRecords;
    @ApiModelProperty(value = "验收操作日志")
    ConstructionAcceptanceRecords acceptanceRecords;

    // 基本信息
    @ApiModelProperty(value = "基本信息")
    SurveyInformationDto surveyInformation;

    @ApiModelProperty(value = "施工派工单Id",example = "1813102468939149314")
    Long workOrderPowerStationId;

    // 资料归档
    @ApiModelProperty(value = "资料归档")
    InformationDto information;

    // 勘察信息详情
    @ApiModelProperty(value = "勘察信息详情")
    SurveyDetailsDto surveyDetails;


    // 扩展信息
    @ApiModelProperty(value = "扩展信息")
    ExtendedInformationDto extendedInformation;

    // 商务信息
    @ApiModelProperty(value = "商务信息")
    CommercialDto commercial;

    //设计信息
    @ApiModelProperty(value = "订单跟踪")
    DesignInformationDto designInformation;

    //订单跟踪
    @ApiModelProperty(value = "订单跟踪")
    LoggerDto orderTracking;


    //工程信息
    @ApiModelProperty(value = "工程信息")
    PowerStationEngineeringInfo powerStationEngineeringInfo;


    //施工信息
    @ApiModelProperty(value = "施工信息")
    PowerStationConstructionData powerStationConstructionData;

    //并网信息
    @ApiModelProperty(value = "并网信息")
    HygfOnGrid hygfOnGrid;

    //派工单信息
    @ApiModelProperty(value = "派工单信息")
    WorkOrder workOrder;
    
    //验收信息
    @ApiModelProperty(value = "验收信息")
    AcceptanceCheck acceptanceCheck;

    @ApiModelProperty(value = "保存标识",example = "0")
    //保存标识 0 保存 1保存并提交
    Integer commitFlag;
    @ApiModelProperty(value = "流程类型",example = "0")
    //流程类型 0 并网 1是验收
    Integer flowType;
}
