package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.hygf.api.dto.HygfIcbcRecordDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 *  聚富通代扣信息表
 *
 * @author system_generator
 * @date 2024-12-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_icbc_withhold")
public class IcbcWithhold extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 付款目标
     */
	@TableField("payment_target")
    private String paymentTarget;

    /**
     * 项目编号
     */
	@TableField("project_number")
    private String projectNumber;

    /**
     * 付款金额
     */
	@TableField("payment_amount")
    private String paymentAmount;

    /**
     * 说明
     */
	@TableField("content")
    private String desc;

    /**
     * 确认人员
     */
	@TableField("confirmator")
    private String confirmator;

    /**
     * 确认时间
     */
	@TableField("confirmation_time")
    private Date confirmationTime;

    /**
     * 上传人员
     */
	@TableField("uploader")
    private String uploader;

    /**
     * 上传时间
     */
	@TableField("upload_time")
    private Date uploadTime;

    /**
     * 上传文件
     */
	@TableField("upload_file")
    private String uploadFile;
	/**
     * 上传文件生成名称
     */
	@TableField("upload_fileName")
    private String uploadFileName;

	/**
     * 上传文件
     */
	@TableField("receipt_file")
    private String receiptFile;

    /**
     * 上传状态
     */
	@TableField("upload_status")
    private String uploadStatus;

    /**
     * 代扣状态
     */
	@TableField("withhold_status")
    private String withholdStatus;

    /**
     * 失败原因
     */
	@TableField("upload_error_desc")
    private String uploadErrorDesc;
	/**
     * 失败原因
     */
	@TableField("payment_error_desc")
    private String paymentErrorDesc;

    /**
     * 户主icbcid 弃用冗余  传递导出参数使用
     */
	@TableField("icbc_id")
    private String icbcId;

    /**
     * 批次号
     */
    @TableField("batch_no")
    private String batchNo;
    /**
     * 所选商户冗余
     */
    @TableField("icbc_record_infos")
    private String icbcRecordInfos;

    /**
     * 付款信息
     */
    @TableField(exist = false)
    private List<IcbcWithholdRecord> recordDTOS;

}
