package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.AllPowerDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.AllPowerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 统计所有功率
 *
 * @author system_generator
 * @date 2023-09-20
 */
@RestController
@Api(tags = "统计所有功率Api")
@RequestMapping(value = "/all-power")
public class AllPowerController extends BaseController {

    @Autowired
    AllPowerServiceImpl allPowerServiceImpl;

    /**
     * 新增统计所有功率
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增统计所有功率", notes = "新增统计所有功率")
	public ResponseModel<AllPowerDto> save(@RequestBody AllPowerDto model) {
	    model = allPowerServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新统计所有功率", notes = "根据sequenceNbr更新统计所有功率")
	public ResponseModel<AllPowerDto> updateBySequenceNbrAllPower(@RequestBody AllPowerDto model,@ApiParam(value = "主键",example = "1805040753609568257")@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    return ResponseHelper.buildResponse(allPowerServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除统计所有功率", notes = "根据sequenceNbr删除统计所有功率")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,@ApiParam(value = "主键",example = "1805040753609568257")@PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(allPowerServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个统计所有功率",  notes = "根据sequenceNbr查询单个统计所有功率")
	public ResponseModel<AllPowerDto> selectOne(@ApiParam(value = "主键",example = "1805040753609568257")@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(allPowerServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "统计所有功率分页查询",  notes = "统计所有功率分页查询")
	public ResponseModel<Page<AllPowerDto>> queryForPage(@ApiParam(value = "当前页码",example = "1")@RequestParam(value = "current") int current,
            @ApiParam(value = "分页条数",example = "20")@RequestParam(value = "size") int size) {
	    Page<AllPowerDto> page = new Page<AllPowerDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(allPowerServiceImpl.queryForAllPowerPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "统计所有功率列表全部数据查询",   notes = "统计所有功率列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<AllPowerDto>> selectForList() {
	    return ResponseHelper.buildResponse(allPowerServiceImpl.queryForAllPowerList());
	}
}
