package com.yeejoin.amos.boot.module.hygf.biz.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.RepaymentBatchDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.RepaymentDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.Repayment;
import com.yeejoin.amos.boot.module.hygf.api.util.FileUtil;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.RepaymentServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 *
 *
 * @author 还款管理
 * @date 2024-09-26
 */
@RestController
@Api(tags = "还款管理Api")
@RequestMapping(value = "/repayment")
public class RepaymentController extends BaseController {
    @Autowired
    RepaymentServiceImpl repaymentService;

    /**
     * 定时任务
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/cronTest")
    @ApiOperation(httpMethod = "GET", value = "定时任务", notes = "定时任务")
    public ResponseModel<?> cronTest() {
        repaymentService.cronSendRepayMessage();
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/addOrUpdate")
    @ApiOperation(httpMethod = "POST", value = "新增或编辑", notes = "新增或编辑")
    public ResponseModel<RepaymentDto> addOrUpdate(@RequestBody RepaymentDto model) {
        repaymentService.addOrUpdate(model);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/updateBySequenceNbr")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<?> updateBySequenceNbr(@RequestBody Repayment model) {
        repaymentService.updateBySequenceNbr(model);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr确认消息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/messageBySequenceNbr")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr确认消息", notes = "根据sequenceNbr确认消息")
    public ResponseModel<?> confirmMessageState(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        repaymentService.confirmMessageState(sequenceNbr);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr还款
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/repayBySequenceNbr")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr还款", notes = "根据sequenceNbr还款")
    public ResponseModel<?> repayBySequenceNbr(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        repaymentService.repay(sequenceNbr);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr批量确认消息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/batchConfirmMessageState")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr批量确认消息", notes = "根据sequenceNbr批量确认消息")
    public ResponseModel<?> batchConfirmMessageState(@RequestBody RepaymentBatchDto repaymentBatchDto) {
        repaymentService.batchConfirmMessageState(repaymentBatchDto.getSequenceNbrList());
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr批量还款
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/batchRepay")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr批量还款", notes = "根据sequenceNbr批量还款")
    public ResponseModel<?> batchRepay(@RequestBody RepaymentBatchDto repaymentBatchDto) {
        repaymentService.batchRepay(repaymentBatchDto.getSequenceNbrList());
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr批量删除
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/batchDelete")
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr批量删除", notes = "根据sequenceNbr批量删除")
    public ResponseModel<?> deleteBySequenceNbr(@RequestBody RepaymentBatchDto repaymentBatchDto) {
        repaymentService.deleteBatch(repaymentBatchDto);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 导入还款模板Excel
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/importRepaymentExcel")
    @ApiOperation(httpMethod = "POST", value = "导入还款模板Excel", notes = "导入还款模板Excel")
    public ResponseModel<?> importRepaymentExcel(@RequestPart("file") MultipartFile file) {
        repaymentService.importRepaymentExcel(file);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 导出还款Excel
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/exportRepaymentExcel")
    @ApiOperation(httpMethod = "POST", value = "导出还款Excel", notes = "导出还款Excel")
    public ResponseModel<?> exportRepaymentExcel(@RequestBody RepaymentBatchDto repaymentBatchDto, HttpServletResponse response) {
        repaymentService.exportRepaymentExcel(repaymentBatchDto.getSequenceNbrList(), response);
        return ResponseHelper.buildResponse(null);
    }

    @GetMapping(value = "/exportTemplates")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "模板下载", notes = "模板下载")
    public void exportTemplates(HttpServletResponse response) {
        FileUtil.downloadResource("还款管理导入模板.xlsx", "templates/repaymentTemplates.xlsx", response);
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<?> deleteBySequenceNbr(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        repaymentService.deleteBySequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr  主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/selectDetail")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<RepaymentDto> selectOne(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        RepaymentDto repaymentDto = repaymentService.queryBySeq(sequenceNbr);
        return ResponseHelper.buildResponse(repaymentDto);
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<RepaymentDto>> queryForPage(@RequestParam(value = "sequenceNbr",required = false) String sequenceNbr,
                                                          @RequestParam(value = "companyName",required = false) String companyName,
                                                          @RequestParam(value = "loanPeriod",required = false) String loanPeriod,
                                                          @RequestParam(value = "messageState",required = false) String messageState,
                                                          @RequestParam(value = "repayState",required = false) String repayState,
                                                          @RequestParam(value = "repayDate",required = false) String repayDate,
                                                          @RequestParam(value = "period",required = false) String period,
                                                          @RequestParam(value = "current") int current,
                                                          @RequestParam(value = "size") int size) {
        return ResponseHelper.buildResponse(repaymentService.queryForRepaymentPage(sequenceNbr, companyName,loanPeriod,messageState,repayState,repayDate,period,current, size));
    }
}
