package com.yeejoin.amos.boot.module.hygf.biz.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ApiModel(value = "PowerStationTimeStatisticsExcelVO", description = "电站统计excel实体类")
public class PowerStationTimeStatisticsExcelVO implements Serializable {
    private static final long serialVersionUID = 1L;
    
    @Excel(name = "电站名称", width = 30, orderNum = "1")
    @ApiModelProperty(value = "电站名称")
    private String ownersName;

    @Excel(name = "电站安装规模(kW)", width = 30, orderNum = "2")
    @ApiModelProperty(value = "电站安装规模")
    private String scale;

    @Excel(name = "电站实际规模(kW)", width = 30, orderNum = "3")
    @ApiModelProperty(value = "电站实际规模")
    private String realScale;

    @Excel(name = "省份", width = 30, orderNum = "4")
    @ApiModelProperty(value = "省份")
    private String province;

    @Excel(name = "区域公司", width = 50, orderNum = "5")
    @ApiModelProperty(value = "区域公司")
    private String regionalCompaniesName;

    @Excel(name = "经销商", width = 30, orderNum = "6")
    @ApiModelProperty(value = "经销商")
    private String serviceAgent;

    @Excel(name = "勘察开始时间", width = 30, orderNum = "7")
    @ApiModelProperty(value = "勘察开始时间")
    private String kcCreateTime;

    @Excel(name = "勘察结束时间", width = 30, orderNum = "8")
    @ApiModelProperty(value = "勘察结束时间")
    private String kcEndTime;

    @Excel(name = "勘察停留时间", width = 30, orderNum = "9")
    @ApiModelProperty(value = "勘察停留时间")
    private String kcStopTime;

    @Excel(name = "电子合同签约开始时间", width = 30, orderNum = "10")
    @ApiModelProperty(value = "电子合同签约开始时间")
    private String dzhtqyCreateTime;

    @Excel(name = "电子合同签约结束时间", width = 30, orderNum = "11")
    @ApiModelProperty(value = "电子合同签约结束时间")
    private String dzhtqyEndTime;

    @Excel(name = "电子合同签约停留时间", width = 30, orderNum = "12")
    @ApiModelProperty(value = "电子合同签约停留时间")
    private String dzhtqyStopTime;

    @Excel(name = "设计开始时间", width = 30, orderNum = "13")
    @ApiModelProperty(value = "设计开始时间")
    private String sjCreateTime;

    @Excel(name = "设计结束时间", width = 30, orderNum = "14")
    @ApiModelProperty(value = "设计结束时间")
    private String sjEndTime;

    @Excel(name = "设计停留时间", width = 30, orderNum = "15")
    @ApiModelProperty(value = "设计停留时间")
    private String sjStopTime;

    @Excel(name = "发货备货开始时间", width = 30, orderNum = "16")
    @ApiModelProperty(value = "发货备货开始时间")
    private String fhbhCreateTime;

    @Excel(name = "发货备货结束时间", width = 30, orderNum = "17")
    @ApiModelProperty(value = "发货备货结束时间")
    private String fhbhEndTime;

    @Excel(name = "发货备货停留时间", width = 30, orderNum = "18")
    @ApiModelProperty(value = "发货备货停留时间")
    private String fhbhStopTime;

    @Excel(name = "施工开始时间", width = 30, orderNum = "19")
    @ApiModelProperty(value = "施工开始时间")
    private String sgCreateTime;

    @Excel(name = "施工结束时间", width = 30, orderNum = "20")
    @ApiModelProperty(value = "施工结束时间")
    private String sgEndTime;

    @Excel(name = "施工停留时间", width = 30, orderNum = "21")
    @ApiModelProperty(value = "施工停留时间")
    private String sgStopTime;

    @Excel(name = "并网开始时间", width = 30, orderNum = "22")
    @ApiModelProperty(value = "并网开始时间")
    private String bwCreateTime;

    @Excel(name = "并网结束时间", width = 30, orderNum = "23")
    @ApiModelProperty(value = "并网结束时间")
    private String bwEndTime;

    @Excel(name = "并网停留时间", width = 30, orderNum = "24")
    @ApiModelProperty(value = "并网停留时间")
    private String bwStopTime;

    @Excel(name = "验收开始时间", width = 30, orderNum = "25")
    @ApiModelProperty(value = "验收开始时间")
    private String ysCreateTime;

    @Excel(name = "验收结束时间", width = 30, orderNum = "26")
    @ApiModelProperty(value = "验收结束时间")
    private String ysEndTime;

    @Excel(name = "验收停留时间", width = 30, orderNum = "27")
    @ApiModelProperty(value = "验收停留时间")
    private String ysStopTime;

    @Excel(name = "投融开始时间", width = 30, orderNum = "28")
    @ApiModelProperty(value = "投融开始时间")
    private String trCreateTime;

    @Excel(name = "投融结束时间", width = 30, orderNum = "29")
    @ApiModelProperty(value = "投融结束时间")
    private String trEndTime;

    @Excel(name = "投融停留时间", width = 30, orderNum = "30")
    @ApiModelProperty(value = "投融停留时间")
    private String trStopTime;
}
