package com.yeejoin.amos.boot.module.jxiop.biz.kafka;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanPointProcessVariableClassification;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanPointVarCorrelation;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvPointProcessVariableClassification;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvPointVarCorrelation;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanPointProcessVariableClassificationMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanPointVarCorrelationMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizPvPointProcessVariableClassificationMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizPvPointVarCorrelationMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.yeejoin.amos.boot.module.jxiop.biz.kafka.Constant.*;


@Service
@Slf4j
public class FanConditionVariablesMessage {

    @Autowired
    private IdxBizFanPointVarCorrelationMapper pointVarCorrelationMapper;

    @Autowired
    private IdxBizPvPointVarCorrelationMapper pointVarCorrelationMapperPv;

    @Autowired
    private IdxBizFanPointProcessVariableClassificationMapper classificationMapperFan;

    @Autowired
    private IdxBizPvPointProcessVariableClassificationMapper classificationMapperPv;


    @Autowired
    private KafkaProducerService kafkaProducerService;

    // 相关性分析-风机入口
    @Async
    public void getFanConditionVariables() {
        List<IdxBizFanPointVarCorrelation> pointVarCorrelationsList = initFanPointVar();
        log.debug("==================初始化了{}条数据==============================",pointVarCorrelationsList.size());
        pointVarCorrelationsList.forEach(item -> kafkaProducerService.sendMessageAsync(kafkaTopicConsumer, JSON.toJSONString(item)));
    }

    /**
     * 初始化风机的相关性分析
     * @return
     */
    private  List<IdxBizFanPointVarCorrelation> initFanPointVar() {
       //清空表
        pointVarCorrelationMapper.delete(null);
        Date recDate = new Date();
        Sequence sequence = new Sequence();
        List<IdxBizFanPointProcessVariableClassification> gkblList = classificationMapperFan.selectList(new QueryWrapper<IdxBizFanPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "工况变量"));
        List<IdxBizFanPointProcessVariableClassification> fxblList = classificationMapperFan.selectList(new QueryWrapper<IdxBizFanPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "分析变量"));
        List<IdxBizFanPointVarCorrelation> fanPointVarCorrelations=new ArrayList<>();
        //工况变量和分析变量不为空 进行计算 总数值=同一设备的工况变量*分析变量
        if(CollectionUtil.isNotEmpty(gkblList) && CollectionUtil.isNotEmpty(fxblList)){
            //聚合同一设备
            Map<String, List<IdxBizFanPointProcessVariableClassification>> fxblMap = fxblList.stream().collect(Collectors.groupingBy(IdxBizFanPointProcessVariableClassification::getEquipmentName));
            gkblList.forEach(item ->{
                fxblMap.get(item.getEquipmentName()).forEach(item1->{
                    IdxBizFanPointVarCorrelation idxBizFanPointVarCorrelation = BeanUtil.copyProperties(item, IdxBizFanPointVarCorrelation.class);
                    idxBizFanPointVarCorrelation.setSequenceNbr(String.valueOf(sequence.nextId()));
                    idxBizFanPointVarCorrelation.setRecDate(recDate);
                    idxBizFanPointVarCorrelation.setCorrelationCoefficient(0.0);
                    idxBizFanPointVarCorrelation.setAnalysisPointId(Long.valueOf(item1.getSequenceNbr()));
                    idxBizFanPointVarCorrelation.setProcessPointId(Long.valueOf(item.getSequenceNbr()));
                    idxBizFanPointVarCorrelation.setDeviceType(null);
                    idxBizFanPointVarCorrelation.setAnalysisGatewayId(item1.getGatewayId());
                    idxBizFanPointVarCorrelation.setAnalysisIndexAddress(item1.getIndexAddress());
                    idxBizFanPointVarCorrelation.setProcessGatewayId(item.getGatewayId());
                    idxBizFanPointVarCorrelation.setProcessIndexAddress(item.getIndexAddress());
                    idxBizFanPointVarCorrelation.setAnalysisPointName(item1.getPointName());
                    idxBizFanPointVarCorrelation.setProcessPointName(item.getPointName());
                    idxBizFanPointVarCorrelation.setMatchProcessPoint("匹配");
                    fanPointVarCorrelations.add(idxBizFanPointVarCorrelation);
                });
            });
        }
        return fanPointVarCorrelations;
    }

    // 相关性分析-光伏入口
    @Async
    public void getPvConditionVariables() {
        List<IdxBizPvPointVarCorrelation> pointVarCorrelationsList = initPvPointVar();
        log.debug("==============初始化了光伏{}条数据===============",pointVarCorrelationsList.size());
        pointVarCorrelationsList.forEach(item -> kafkaProducerService.sendMessageAsync(kafkaTopicConsumerPv, JSON.toJSONString(item)));
    }

    /**
     * 初始化光伏的相关性分析
     */
    private List<IdxBizPvPointVarCorrelation> initPvPointVar() {
        //清空表
        pointVarCorrelationMapper.delete(null);
        Date recDate = new Date();
        Sequence sequence = new Sequence();
        List<IdxBizPvPointProcessVariableClassification> gkblList = classificationMapperPv.selectList(new QueryWrapper<IdxBizPvPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "工况变量"));
        List<IdxBizPvPointProcessVariableClassification> fxblList = classificationMapperPv.selectList(new QueryWrapper<IdxBizPvPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "分析变量"));
        List<IdxBizPvPointVarCorrelation> pvPointVarCorrelations =new ArrayList<>();
        //工况变量和分析变量不为空 进行计算 总数值=同一设备的工况变量*分析变量
        if(CollectionUtil.isNotEmpty(gkblList) && CollectionUtil.isNotEmpty(fxblList)){
            //聚合同一设备
            Map<String, List<IdxBizPvPointProcessVariableClassification>> fxblMap = fxblList.stream().collect(Collectors.groupingBy(IdxBizPvPointProcessVariableClassification::getEquipmentName));
            gkblList.forEach(item ->{
                fxblMap.get(item.getEquipmentName()).forEach(item1->{
                    IdxBizPvPointVarCorrelation idxBizPvPointVarCorrelation = BeanUtil.copyProperties(item, IdxBizPvPointVarCorrelation.class);
                    idxBizPvPointVarCorrelation.setSequenceNbr(String.valueOf(sequence.nextId()));
                    idxBizPvPointVarCorrelation.setRecDate(recDate);
                    idxBizPvPointVarCorrelation.setCorrelationCoefficient(0.0);
                    idxBizPvPointVarCorrelation.setAnalysisPointId(item1.getSequenceNbr());
                    idxBizPvPointVarCorrelation.setProcessPointId(item.getSequenceNbr());
                    idxBizPvPointVarCorrelation.setDeviceType(item.getDeviceType());
                    idxBizPvPointVarCorrelation.setAnalysisGatewayId(item1.getGatewayId());
                    idxBizPvPointVarCorrelation.setAnalysisIndexAddress(Integer.valueOf(item1.getIndexAddress()));
                    idxBizPvPointVarCorrelation.setProcessGatewayId(item.getGatewayId());
                    idxBizPvPointVarCorrelation.setProcessIndexAddress(item.getIndexAddress());
                    idxBizPvPointVarCorrelation.setAnalysisPointName(item1.getPointName());
                    idxBizPvPointVarCorrelation.setProcessPointName(item.getPointName());
                    idxBizPvPointVarCorrelation.setMatchProcessPoint("匹配");
                    pvPointVarCorrelations.add(idxBizPvPointVarCorrelation);
                });
            });
        }
        return pvPointVarCorrelations;
    }

    // 工况划分 - 风电 - 新
    @Async
    public void getFanConditionVariablesGKHF() {
        List<IdxBizFanPointProcessVariableClassification> variableClassificationList = classificationMapperFan.selectList(new QueryWrapper<IdxBizFanPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "工况变量"));
        variableClassificationList.forEach(item -> kafkaProducerService.sendMessageAsync(kafkaTopicConsumerGKHFFan, JSON.toJSONString(item)));
    }

    // 工况划分 - 光伏 - 新
    @Async
    public void getPvConditionVariablesPvGKFX() {
        List<IdxBizPvPointProcessVariableClassification> variableClassificationList = classificationMapperPv.selectList(new QueryWrapper<IdxBizPvPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "工况变量"));
        variableClassificationList.forEach(item -> kafkaProducerService.sendMessageAsync(kafkaTopicConsumerGKHFPv, JSON.toJSONString(item)));
    }

    // 中心值 - 风电 - 新
    @Async
    public void getFanConditionVariablesZXZ() {
        List<IdxBizFanPointProcessVariableClassification> fenxiList = classificationMapperFan.selectList(new QueryWrapper<IdxBizFanPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "分析变量"));
        fenxiList.forEach(item -> kafkaProducerService.sendMessageAsync(kafkaTopicConsumerZXZFan, JSON.toJSONString(item)));
    }

    // 中心值 - 风电 - 新
    @Async
    public void getPvConditionVariablesZXZ() {
        List<IdxBizPvPointProcessVariableClassification> fenxiList = classificationMapperPv.selectList(new QueryWrapper<IdxBizPvPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "分析变量"));
        fenxiList.forEach(item -> kafkaProducerService.sendMessageAsync(kafkaTopicConsumerZXZPv, JSON.toJSONString(item)));
    }
}
