package com.yeejoin.amos.boot.module.jxiop.biz.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jxiop.api.dto.ProduceMsg;
import com.yeejoin.amos.boot.module.jxiop.api.entity.PersonAccount;
import com.yeejoin.amos.boot.module.jxiop.api.entity.PersonAccountFed;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.PersonAccountFedMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.PersonAccountMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.activemq.QuerueProduce;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import lombok.extern.slf4j.Slf4j;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.Map;

import javax.jms.Message;

@Component
@Slf4j
public class PlatformModifyPasswordistener {
    @Autowired
    PersonAccountMapper personAccountMapper;
    @Autowired
    PersonAccountFedMapper personAccountFedMapper;
    @Value("${amos.secret.key}")
    private String secretKey;    
    @Autowired
    QuerueProduce querueProduce;

    @JmsListener(destination = "${modifypasswordqueue}")
    public void reciveMesssage(Message message) {
        try {
            String dadainfo = ((ActiveMQTextMessage) message).getText();
            JSONObject jsonObject = JSONObject.parseObject(dadainfo);
            jsonObject = (JSONObject) jsonObject.get("body");
            jsonObject = (JSONObject) jsonObject.get("authData");
            PersonAccount personAccount = personAccountMapper.selectOne(new QueryWrapper<PersonAccount>().eq("puser_id", jsonObject.get("userId")));
            if (!ObjectUtils.isEmpty(personAccount)) {
                personAccount.setPassword((String) jsonObject.get("password"));
                personAccount.setSecondaryPassword((String) jsonObject.get("rePassword"));
                personAccountMapper.updateById(personAccount);
            }
            PersonAccountFed personAccountFed = personAccountFedMapper.selectOne(new QueryWrapper<PersonAccountFed>().eq("puser_id", jsonObject.get("userId")));
            if (!ObjectUtils.isEmpty(personAccount)) {
                personAccountFed.setPassword((String) jsonObject.get("password"));
                personAccountFed.setSecondaryPassword((String) jsonObject.get("rePassword"));
                personAccountFedMapper.updateById(personAccountFed);
            }
            
            //发消息通知集成方修改
            if(personAccount!=null) 
            {
                Map<String, Object> data=new HashMap<>();          
                data.put("SEQUENCE_NBR",jsonObject.get("sequenceNbr"));
                ProduceMsg produceMsg=  new ProduceMsg(data, "UPDATE",personAccount.getPuserId());
                querueProduce.produceMsg(JSON.toJSONString(produceMsg));
            }
            message.acknowledge();
            log.info("--------------------消息消费成功 {}", jsonObject);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
        }
    }
}
