package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description:
 * @author: keyong
 * @createDate: 2024/01/16
 */
@Getter
@AllArgsConstructor
public enum GridStatusEnum {


    DDJ("待登记", "1"),

    DSH("待审核", "2"),

    YWC("已完成", "3"),

    WTG("未通过", "4");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    public static GridStatusEnum getNodeByCode(String code) {
        GridStatusEnum gridStatusEnum = null;
        for(GridStatusEnum type: GridStatusEnum.values()) {
            if (type.getCode().equals(code)) {
                gridStatusEnum = type;
                break;
            }
        }
        return gridStatusEnum;
    }

}
