package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;

/**
 *
 * @author Provence
 * @version v1.0
 * @date 2023/8/21 15:15
 */
@Data
public class MobileLoginParamDto {

    @ApiModelProperty("用户userid")
    private String amosUserId;

    @ApiModelProperty("二维码类型：region, personal")
    private String qrCodeType;

    /**
     * 注册类型：1-微信授权快捷登录；2-手机验证登录
     */
    @ApiModelProperty("注册类型：1-微信授权快捷登录；2-手机验证登录")
    private int registerType;

    /**
     * 是否需要需要短信验证： true-验证； false-不验证
     */
    @ApiModelProperty("是否需要需要短信验证： true-验证； false-不验证")
    private Boolean isNeedVerify;

    /**
     * 注册类型为1时使用：微信用户数据字段1,根据1、2进行数据解密，计算出手机号
     */
    @ApiModelProperty("注册类型为1时使用：微信用户数据字段1,根据1、2进行数据解密，计算出手机号")
    private String encryptedData;

    /**
     * 注册类型为1时使用：微信用户数据字段2,根据1、2进行数据解密，计算出手机号
     */
    @ApiModelProperty("注册类型为1时使用：微信用户数据字段1,根据1、2进行数据解密，计算出手机号")
    private String iv;

    /**
     *注册类型为1时使用：微信用户数据字段3,根据1、2、3进行数据解密，计算出手机号
     */
    @ApiModelProperty("注册类型为1时使用：微信用户数据字段3,根据1、2、3进行数据解密，计算出手机号")
    private String code;

    /**
     * 注册类型为2-手机验证登录时使用：手机号
     */
    @ApiModelProperty("注册类型为2-手机验证登录时使用：手机号")
    private String phoneNo;

    /**
     *  注册类型为2-手机验证登录时使用：验证码
     */
    @ApiModelProperty("注册类型为2-手机验证登录时使用：验证码")
    private String verifyCode;

    @ApiModelProperty("农户信息")
    private @Valid PeasantHouseholdDto peasantHouseholdDto;
}
