package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/9/1
 */
@Data
public class UnitInformation {

    protected Long sequenceNbr;

    @ApiModelProperty(value = "企业名称")
    private String name;

    @ApiModelProperty(value = "注册地址")
    private String registerAddress;

    @ApiModelProperty(value = "工作地址")
    private String workAddress;

    @ApiModelProperty(value = "负责人名称")
    private String headName;

    @ApiModelProperty(value = "负责人电话")
    private String headPhone;

    @ApiModelProperty(value = "负责人身份证号码")
    private String headIdNumber;

    @ApiModelProperty(value = "负责人身份证照片正面")
    private String headCardPhotoFront;
    private List<FileDto> headCardPhotoFrontUrl;

    @ApiModelProperty(value = "负责人身份证照片反面")
    private String headCardPhotoBack;
    private List<FileDto> headCardPhotoBackUrl;


    @ApiModelProperty(value = "注册地址省-市-区")
    private String registerPcd;

    @ApiModelProperty(value = "工作地址省-市-区")
    private String workPcd;

    @ApiModelProperty(value = "注册地址省-市-区code")
    private String registerPcdCode;

    @ApiModelProperty(value = "工作地址省-市-区code")
    private String workPcdCode;

    @ApiModelProperty(value = "注册地址省-市-区code")
    private List<Integer> registerPcdCodeList;

    @ApiModelProperty(value = "工作地址省-市-区code")
    private List<Integer>  workPcdCodeList;


    @ApiModelProperty(value = "单位类型")
    private String unitTypeCode;
    @ApiModelProperty(value = "区域公司")
    private List<Long> regionalCompaniesSeq;


    public void setRegisterPcdCodeList(List<Integer> registerPcdCodeList) {
        StringBuilder code=new StringBuilder();
        if(registerPcdCodeList!=null&&!registerPcdCodeList.isEmpty()&&!registerPcdCodeList.isEmpty()){
            for (int i = 0, len = registerPcdCodeList.size(); i < len; i++) {
                code.append(registerPcdCodeList.get(i).toString());
                if(i != len-1) {
                    code.append("-");
                }
            }

        }

        this.registerPcdCode =code!=null&&!code.toString().isEmpty()? code.toString():null;
        this.registerPcdCodeList = registerPcdCodeList;
    }

    public void setWorkPcdCodeList(List<Integer> workPcdCodeList) {
        StringBuilder code=new StringBuilder();
        if(workPcdCodeList!=null&&!workPcdCodeList.isEmpty()&&!workPcdCodeList.isEmpty()){
            for (int i = 0, len = workPcdCodeList.size(); i < len; i++) {
                code.append(workPcdCodeList.get(i).toString());
                if(i != len-1) {
                    code.append("-");
                }
            }

        }

        this.workPcdCode = code!=null&&!code.toString().isEmpty()? code.toString():null;
        this.workPcdCodeList = workPcdCodeList;
    }

    public void setRegisterPcdCode(String registerPcdCode) {
        if(this.registerPcdCode!=null&&!this.registerPcdCode.isEmpty()&&this.registerPcdCodeList ==null){
        List<Integer> registerPcdCodeList =new ArrayList<>();
        String[] da=  registerPcdCode.split("-");
            for (String s : da) {
                registerPcdCodeList.add(Integer.valueOf(s));
            }
        this.registerPcdCodeList =registerPcdCodeList;
    }

        this.registerPcdCode = registerPcdCode;
    }

    public void setWorkPcdCode(String workPcdCode) {
        if(this.workPcdCode!=null&&!this.workPcdCode.isEmpty()&&this.workPcdCodeList==null ){
            List<Integer> workPcdCodeList =new ArrayList<>();
            String[] da=  workPcdCode.split("-");
            for (String s : da) {
                workPcdCodeList.add(Integer.valueOf(s));
            }
            this.workPcdCodeList =workPcdCodeList;
        }
        this.workPcdCode = workPcdCode;
    }

    public void setHeadCardPhotoFront(String headCardPhotoFront) {
        if(this.headCardPhotoFront!=null&&!this.headCardPhotoFront.isEmpty()&&this.headCardPhotoFrontUrl==null){
            List<FileDto> headCardPhotoFrontUrl =new ArrayList<>();
            FileDto d=new FileDto(this.headCardPhotoFront);
            headCardPhotoFrontUrl.add(d);
            this.headCardPhotoFrontUrl =headCardPhotoFrontUrl;
        }
        this.headCardPhotoFront = headCardPhotoFront;
    }

    public void setHeadCardPhotoBack(String headCardPhotoBack) {
        if(this.headCardPhotoBack!=null&&!this.headCardPhotoBack.isEmpty()&&this.headCardPhotoBackUrl==null){
            List<FileDto> headCardPhotoBackUrl =new ArrayList<>();
            FileDto d=new FileDto(this.headCardPhotoBack);
            headCardPhotoBackUrl.add(d);
            this.headCardPhotoBackUrl =headCardPhotoBackUrl;
        }
        this.headCardPhotoBack = headCardPhotoBack;
    }


    public void setHeadCardPhotoFrontUrl(List<FileDto> headCardPhotoFrontUrl) {

        String url=null;
        if(headCardPhotoFrontUrl!=null&&!headCardPhotoFrontUrl.isEmpty()){
            url=headCardPhotoFrontUrl.get(0).getUrl();
        }

        this.headCardPhotoFront=url;
        this.headCardPhotoFrontUrl = headCardPhotoFrontUrl;
    }

    public void setHeadCardPhotoBackUrl(List<FileDto> headCardPhotoBackUrl) {
        String url=null;
        if(headCardPhotoBackUrl!=null&&!headCardPhotoBackUrl.isEmpty()){
            url=headCardPhotoBackUrl.get(0).getUrl();
        }

        this.headCardPhotoBack=url;
        this.headCardPhotoBackUrl = headCardPhotoBackUrl;
    }
}
