package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.PowerStationConstructionDataDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.PowerStationConstructionDataServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 施工电站施工资料
 *
 * @author system_generator
 * @date 2024-01-02
 */
@RestController
@Api(tags = "施工电站施工资料Api")
@RequestMapping(value = "/power-station-construction-data")
public class PowerStationConstructionDataController extends BaseController {

    @Autowired
    PowerStationConstructionDataServiceImpl powerStationConstructionDataServiceImpl;

    /**
     * 新增施工电站施工资料
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增施工电站施工资料", notes = "新增施工电站施工资料")
	public ResponseModel<PowerStationConstructionDataDto> save(@RequestBody PowerStationConstructionDataDto model) {
	    model = powerStationConstructionDataServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新施工电站施工资料", notes = "根据sequenceNbr更新施工电站施工资料")
	public ResponseModel<PowerStationConstructionDataDto> updateBySequenceNbrPowerStationConstructionData(@RequestBody PowerStationConstructionDataDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(powerStationConstructionDataServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除施工电站施工资料", notes = "根据sequenceNbr删除施工电站施工资料")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(powerStationConstructionDataServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个施工电站施工资料",  notes = "根据sequenceNbr查询单个施工电站施工资料")
	public ResponseModel<PowerStationConstructionDataDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(powerStationConstructionDataServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "施工电站施工资料分页查询",  notes = "施工电站施工资料分页查询")
	public ResponseModel<Page<PowerStationConstructionDataDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<PowerStationConstructionDataDto> page = new Page<PowerStationConstructionDataDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(powerStationConstructionDataServiceImpl.queryForPowerStationConstructionDataPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "施工电站施工资料列表全部数据查询",   notes = "施工电站施工资料列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<PowerStationConstructionDataDto>> selectForList() {
	    return ResponseHelper.buildResponse(powerStationConstructionDataServiceImpl.queryForPowerStationConstructionDataList());
	}
}
