package com.yeejoin.amos.api.openapi.face.service;

import com.yeejoin.amos.api.openapi.face.model.SuperviseInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.SuperviseInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.SuperviseInfo;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * 特种设备基本信息-监督管理信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class SuperviseInfoService extends AppBaseService<SuperviseInfoModel, SuperviseInfo, SuperviseInfoMapper> {

    /**
     *
     * 新增监督管理信息
     *
     * @param model 监督管理信息实体类集合
     * @return 成功返回“OK”
     */
    @Transactional(rollbackFor= {Exception.class})
    public String saveSuperviseInfo(List<SuperviseInfo> model) {
        // TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("监督管理信息为空.");
        }
        for (SuperviseInfo models : model) {
//            checkModel(models);
            models.setRecDate(new Date());
            models.setAppId(getAppId());
        }
        this.saveBatch(model);
        return "OK";
    }

    /**
     * 信息校验
     *
     * @param models
     */
//    private static void checkModel(SuperviseInfo models) {
//        if(ValidationUtil.isEmpty(models.getSequenceCode())) {
//            throw new BadRequest("设备唯一标识码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSuperviseCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监管系统唯一编码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getOrgBranchCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"管辖分局组织机构代码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getOrgBranchName())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"管辖分局名称不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncDate())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步时间不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncState())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步状态不能为空！");
//        }
//    }
}
