package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the preplan_picture database table.
 */
@Entity
@Table(name = "f_preplan_picture")
@NamedQuery(name = "PreplanPicture.findAll", query = "SELECT p FROM PreplanPicture p")
public class PreplanPicture extends BasicEntity {
    private static final long serialVersionUID = 1L;

    @Column(name = "create_by")
    private String createBy;

    @Column(name = "equipment_id")
    private Long equipmentId;

    private String name;

    @Lob
    private String picture;

    private String remark;

    private int type;

    public PreplanPicture() {
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Long getEquipmentId() {
        return this.equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

}