package com.yeejoin.amos.knowledgebase.face.model;

import org.typroject.tyboot.core.rdbms.model.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 知识库系统动态选项配置，多用于动态字段配置
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class KnowledgeDynamicsOptionModel extends BaseModel {

    /**
     * 字段名
     */
    private String fieldName;
    /**
     * 中文名
     */
    private String fieldLabel;
    /**
     * 数据类型：文本，数字，枚举,日期
     */
    private String dataType;

    /**
     * 功能标识
     */
    private String functional;

    /**
     * 业务项目标识
     */
    private String appKey;

    private String frontEndConfig;
    /**
     * 机构编号
     */
    private String agencyCode;

    /**
     * 字段分组主键
     **/
    private Long groupSeq;


    private String queryStrategy;

}
