package com.yeejoin.amos.knowledgebase.face.util;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

import java.io.*;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTransformator {
    /**
     * 多个集合合并成一个
     *
     * @param list
     * @return
     */
    public static Set<Long> objSet2LongSet(List<Set> list) {
        Set<Long> res = new HashSet<>();
        for (Set set : list) {
            for (Object o : set) {
                if (o instanceof Long) {
                    res.add((Long) o);
                } else {
                    res.add(Long.parseLong(o.toString()));
                }
            }
        }
        return res;
    }

    /**
     * html内容转text
     *
     * @param htmlContent html文本
     * @return 文本
     */
    public static String htmlContent2Text(String htmlContent) {
        String res = "";
        try {
            Element body = Jsoup.parseBodyFragment(htmlContent, "UTF-8").body();
            body.getElementsByTag("h1").remove();
            res = body.text();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    /**
     * 文件对象转字节数组
     *
     * @throws IOException
     */
    public static byte[] file2Bytes(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file)) {
            return inputStream2Bytes(fis);
        }
    }

    public static byte[] inputStream2Bytes(InputStream is) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream()) {
            // 10M
            byte[] bytes = new byte[1024 * 1024 * 10];
            int len;
            while ((len = is.read(bytes)) > 0) {
                bos.write(bytes, 0, len);
            }
            return bos.toByteArray();
        }
    }
}
