package com.yeejoin.amos.patrol.business.util;

import java.util.HashMap;
import java.util.List;

import org.springframework.util.ObjectUtils;

import com.yeejoin.amos.patrol.business.param.TaskPageParam;
import com.yeejoin.amos.patrol.core.common.request.CommonPageable;
import com.yeejoin.amos.patrol.core.common.request.CommonRequest;

public class TaskPageParamUtil {

	public static HashMap<String, Object> fillTaskInfo(List<CommonRequest> queryRequests, CommonPageable pageable) {
		HashMap<String, Object> param = new HashMap<String, Object>();
		param.put("pageNumber", pageable.getPageNumber());
		param.put("size", pageable.getPageSize());
		if (ObjectUtils.isEmpty(queryRequests)) {
			return param;
		}
		for (CommonRequest request : queryRequests) {
			if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getName())) {
				param.put(request.getName(), request.getValue());
			}
		}
		return param;
	}

	public static HashMap<String, Object> fillTaskInfo(List<CommonRequest> queryRequests) {
		HashMap<String, Object> param = new HashMap<String, Object>();
		for (CommonRequest request : queryRequests) {
			if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getName())) {
				param.put(request.getName(), request.getValue());
			}
		}
		return param;
	}
	
	public static TaskPageParam fillTaskInfo(List<CommonRequest> queryRequests, CommonPageable commonPageable,HashMap<String, Object> perMap) {
		TaskPageParam param = new TaskPageParam();
		param.setOrgCode(perMap.get("orgCode") == null ? null:perMap.get("orgCode").toString());
		param.setDeptId(perMap.get("deptId") == null ? null:perMap.get("deptId").toString());
		param.setUserId(perMap.get("userId") == null ? null:perMap.get("userId").toString());	
		param.setPageNumber(commonPageable.getPageNumber());
		param.setPageSize(commonPageable.getPageSize());
		if (ObjectUtils.isEmpty(queryRequests)) {
			return param;
		}
		for (CommonRequest request : queryRequests) {
			String name = request.getName();
			if("remark".equals(name)){
				param.setRemark(toString(request.getValue()));
			}else if("status".equals(name)){
				param.setStatus(toString(request.getValue()));
			}else if("title".equals(name)){
				param.setTitle(toString(request.getValue()));
			} else if("pointId".equals(name)){
				param.setPointId(toString(request.getValue()));
			} else if("startTime".equals(name)){
				param.setStartTime(toString(request.getValue()));
			} else if("endTime".equals(name)){
				param.setEndTime(toString(request.getValue()));
			} else if("userId".equals(name)){
				param.setUserId(toString(request.getValue()));
			}
		}
		return param;
	}
	
	private static String toString(Object value) {
		if(null ==value || value ==""){
			return null;
		}else{
			return value.toString();
		}		
	}
}
