package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.omg.CORBA.UNKNOWN;

/**
 * @description:通知类型
 * @author: tw
 * @createDate: 2023/8/25
 */
@Getter
@AllArgsConstructor
public enum  CallbackTypeEnum {
    发送签署("SEND_SIGNING", "SEND_SIGNING"),
    发送填参("SEND_FILLING", "SEND_FILLING"),
    完成参数("FILLED", "FILLED"),
    配置流程("CONFIG_FLOW", "CONFIG_FLOW"),
    个人签字 ("PERSONAL", "PERSONAL"),
    经办人签名("OPERATOR", "OPERATOR"),
    法定代表人签字 ("LEGAL_PERSON", "LEGAL_PERSON"),
    企业签章("SEAL", "SEAL"),
    审批并签署 ("AUDIT_SIGN", "AUDIT_SIGN"),
    文件审批("AUDIT", "AUDIT"),
    撤回文件("RECALLED", "RECALLED"),
    退回文件("REJECTED", "REJECTED"),
    文件过期("EXPIRED", "EXPIRED"),
    文件完成("COMPLETE", "COMPLETE"),
    发送作废("SEND_INVALID", "SEND_INVALID"),
    签署作废("INVALIDING", "INVALIDING"),
    作废完成("INVALIDED", "INVALIDED"),
    拒绝作废("INVALID_REJECTED", "INVALID_REJECTED"),
    签署失败("FAILED", "FAILED"),
    未知("UNKNOWN", "UNKNOWN"),
    强制结束("END", "END");
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    public static CallbackTypeEnum getNodeByCode(String code) {
        CallbackTypeEnum dealerReviewEnum = null;
        for(CallbackTypeEnum type: CallbackTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                dealerReviewEnum = type;
                break;
            }
        }
        return dealerReviewEnum;
    }
}
