package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * 按月统计
 *
 * @author system_generator
 * @date 2023-09-20
 */
@Data
@ApiModel(value="MonthPowerDto", description="按月统计")
public class MonthPowerDto  {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "第三方电站id")
    private String thirdStationId;

    @ApiModelProperty(value = "日期")
    private String day;

    @ApiModelProperty(value = "年月")
    private String yearMonth;

    @ApiModelProperty(value = "平均功率")
    private Double power;




    public MonthPowerDto() {

            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("YYYY-MM-dd");
            String formattedDate = now.format(formatter);
            this.day = formattedDate;

            DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("YYYY-MM");
            String formattedDate1 = now.format(formatter1);
            this.yearMonth = formattedDate1;

    }
}
