package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 勘察信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="SurveyInformationDto", description="勘察信息")
public class SurveyInformationDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "勘察编号")
    private String surveyNumber;

    @ApiModelProperty(value = "电站类型")
    private String powerStationType;

    @ApiModelProperty(value = "开发方名称")
    private String developerName;

    @ApiModelProperty(value = "开发方code")
    private String developerCode;
    @ApiModelProperty(value = "开发方平台id")
    private Long developerId;
    @ApiModelProperty(value = " 业务员id")
    private String salesmanId;

    @ApiModelProperty(value = "业务员名称")
    private String salesman;

    @ApiModelProperty(value = "制单人")
    private String creator;

    @JsonFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "制单时间")
    private Date creatorTime;

    @ApiModelProperty(value = "业主类型")
    private String ownerType;

    @ApiModelProperty(value = " 审核状态 0未审核,1审核中，2审核结束")
    private Integer review;

    @ApiModelProperty(value = "来源农户编号")
    private String peasantHouseholdNo;

    @ApiModelProperty(value = "业主姓名")
    private String ownersName;

    @ApiModelProperty(value = "联系电话")
    private String telephone;

    @ApiModelProperty(value = "身份证号")
    private String idCard;

    @ApiModelProperty(value = "邮箱")
    private String mailbox;

    @ApiModelProperty(value = "项目详细地址")
    private String projectAddressDetail;

    @ApiModelProperty(value = "常住详细地址")
    private String permanentAddressDetail;

    @ApiModelProperty(value = "项目地址code")
   @TableField(typeHandler = FastjsonTypeHandler.class)
   private List<Integer> projectAddress;

   @ApiModelProperty(value = "项目地址文字")
   @TableField(typeHandler = FastjsonTypeHandler.class)
   private List<String> projectAddressText;

    @ApiModelProperty(value = "项目地址")
    private String projectAddressName;

    @ApiModelProperty(value = "常住地址code")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Integer> permanentAddress;

   @ApiModelProperty(value = "常住地址文字")
   @TableField(typeHandler = FastjsonTypeHandler.class)
   private List<String> permanentAddressText;

    @ApiModelProperty(value = "常住是否相同")
    private String isPermanent;


    @ApiModelProperty(value = "定金")
    private Float deposit;

}
