package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 商务信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_commercial",autoResultMap = true)
public class Commercial extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 勘察表id
     */
    @TableField("survey_information_id")
    private Long surveyInformationId;

    /**
     * 商务类型
     */
	@TableField("type")
    private String type;

    /**
     * 申请人
     */
	@TableField("applicant")
    private String applicant;

    /**
     * 身份证号
     */
	@TableField("id_card")
    private String idCard;

    /**
     * 申请人联系电话
     */
	@TableField("telephone")
    private String telephone;

    /**
     * 省市区code
     */
	@TableField(value = "project_address",typeHandler = FastjsonTypeHandler.class)
    private List<Integer> projectAddress;
    /**
     * 省市区名称
     */
    @TableField("project_address_name")
    private String projectAddressName;

    /**
     * 设备信息
     */
	@TableField("device")
    private String device;

    /**
     * 电子系统造价
     */
	@TableField("cost")
    private Float cost;

    /**
     * 安装规模
     */
	@TableField("scale")
    private String scale;

    /**
     * 法务类型
     */
	@TableField("legal_type")
    private String legalType;

    /**
     * 有效联系电话
     */
	@TableField("legal_contact_telephone")
    private String legalContactTelephone;

    /**
     * 紧急联系人
     */
	@TableField("legal_emergent_telephone")
    private String legalEmergentTelephone;

    /**
     * 结婚证文件标识
     */
	@TableField(value = "marriage_credit",typeHandler = FastjsonTypeHandler.class)
    private List<Object> marriageCredit;

    /**
     * 房产证文件标识
     */
	@TableField(value = "real_estate_credit",typeHandler = FastjsonTypeHandler.class)
    private List<Object> realEstateCredit;

    /**
     * 身份证正反面文件标识
     */
	@TableField(value = "id_card_credit",typeHandler = FastjsonTypeHandler.class)
    private List<Object> idCardCredit;

    /**
     * 户口本文件标识
     */
	@TableField(value = "household_book_credit",typeHandler = FastjsonTypeHandler.class)
    private List<Object> householdBookCredit;

    /**
     * 手持身份证文件标识
     */
	@TableField(value = "hand_id_card_credit",typeHandler = FastjsonTypeHandler.class)
    private List<Object> handIdCardCredit;

    /**
     * 踏勘照片文件标识
     */
	@TableField(value = "survey_photos_web",typeHandler = FastjsonTypeHandler.class)
    private List<Object> surveyPhotosWeb;

    /**
     * 组件平面图与组串连线图文件标识
     */
	@TableField(value = "formation_web",typeHandler = FastjsonTypeHandler.class)
    private List<Object> formationWeb;

    /**
     * 房屋所有权继承说明文件标识
     */
	@TableField(value = "inherit_web",typeHandler = FastjsonTypeHandler.class)
    private List<Object> inheritWeb;

    /**
     * 户用光伏电站项目合作协议文件标识
     */
	@TableField(value = "agreement_web",typeHandler = FastjsonTypeHandler.class)
    private List<Object> agreementWeb;

    /**
     * 用户手持身份证照片文件标识
     */
	@TableField(value = "hand_id_card_legal",typeHandler = FastjsonTypeHandler.class)
    private List<Object> handIdCardLegal;

    /**
     * 法人营业执照文件标识
     */
	@TableField(value = "license_legal",typeHandler = FastjsonTypeHandler.class)
    private List<Object> licenseLegal;

    /**
     * 法定代理人身份证文件标识
     */
	@TableField(value = "agent_legal",typeHandler = FastjsonTypeHandler.class)
    private List<Object> agentLegal;

    /**
     * 房产证明文件或乡镇街道土管部门房屋产权证明文件文件标识
     */
	@TableField(value = "real_estate_legal",typeHandler = FastjsonTypeHandler.class)
    private List<Object> realEstateLegal;

    /**
     * 房屋屋顶租赁协议/户用光伏共建开发协议文件标识
     */
	@TableField(value = "house_agreement_legal",typeHandler = FastjsonTypeHandler.class)
    private List<Object> houseAgreementLegal;

    /**
     * 法人的企业征信报告、工商内档文件标识
     */
	@TableField(value = "credit_report_legal",typeHandler = FastjsonTypeHandler.class)
    private List<Object> creditReportLegal;

    /**
     * 项目备案证文件标识
     */
	@TableField(value = "filings_legal",typeHandler = FastjsonTypeHandler.class)
    private List<Object> filingsLegal;

    /**
     *  省市区详细地址
     */
	@TableField("project_address_detail")
    private String projectAddressDetail;

}
