package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 户用光伏监盘逆变器电能历史表
 *
 * @author system_generator
 * @date 2023-09-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("td_hygf_jp_invertor_elec_history_year")
public class JpInvertorElecHistoryYear extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * sn编码
     */
	@TableField("sn_code")
    private String snCode;

    /**
     * U交流电压
     */
	@TableField("U_AC_voltage")
    private Double uAcVoltage;

    /**
     * V交流电压
     */
	@TableField("V_AC_voltage")
    private Double vAcVoltage;

    /**
     * W交流电压
     */
	@TableField("W_AC_voltage")
    private Double wAcVoltage;

    /**
     * U交流电流
     */
	@TableField("U_AC_current")
    private Double uAcCurrent;

    /**
     * V交流电流
     */
	@TableField("V_AC_current")
    private Double vAcCurrent;

    /**
     * W交流电流
     */
	@TableField("W_AC_current")
    private Double wAcCurrent;

    /**
     * 第三方电站id
     */
	@TableField("third_station_id")
    private String thirdStationId;

    /**
     * 第三方厂商标识
     */
	@TableField("third_code")
    private String thirdCode;

    /**
     * 日期
     */
	@TableField("day")
    private String day;

    /**
     * 年月
     */
	@TableField("year_month")
    private String yearMonth;

}
