package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpInverterServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInverterDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpPersonStation;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpPersonStationMapper;

import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 户用光伏监盘逆变器表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@RestController
@Api(tags = "户用光伏监盘逆变器表Api")
@RequestMapping(value = "/jp-inverter")
public class JpInverterController extends BaseController {

	@Autowired
	JpInverterServiceImpl jpInverterServiceImpl;
	
	@Autowired
	JpPersonStationMapper pPersonStationMapper;


	/**
	 * 新增户用光伏监盘逆变器表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏监盘逆变器表", notes = "新增户用光伏监盘逆变器表")
	public ResponseModel<JpInverterDto> save(@RequestBody JpInverterDto model) {
		model = jpInverterServiceImpl.createWithModel(model);
		return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏监盘逆变器表", notes = "根据sequenceNbr更新户用光伏监盘逆变器表")
	public ResponseModel<JpInverterDto> updateBySequenceNbrJpInverter(@RequestBody JpInverterDto model,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setSequenceNbr(sequenceNbr);
		return ResponseHelper.buildResponse(jpInverterServiceImpl.updateWithModel(model));
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏监盘逆变器表", notes = "根据sequenceNbr删除户用光伏监盘逆变器表")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(jpInverterServiceImpl.removeById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个户用光伏监盘逆变器表", notes = "根据sequenceNbr查询单个户用光伏监盘逆变器表")
	public ResponseModel<JpInverterDto> selectOne(@PathVariable Long sequenceNbr) {
        JpInverterDto jpInverter=  jpInverterServiceImpl.queryBySeq(sequenceNbr);
        jpInverter.setDayPowerGeneration(jpInverter.getDayPowerGeneration()!=null?jpInverter.getDayPowerGeneration()/1000:0);
        jpInverter.setMonthPowerGeneration(jpInverter.getMonthPowerGeneration()!=null?jpInverter.getMonthPowerGeneration()/1000:0);
        jpInverter.setYearPowerGeneration(jpInverter.getYearPowerGeneration()!=null?jpInverter.getYearPowerGeneration()/1000:0);
        jpInverter.setTotalPowerGeneration(jpInverter.getTotalPowerGeneration()!=null?jpInverter.getTotalPowerGeneration()/1000:0);
        return ResponseHelper.buildResponse(jpInverter);
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘逆变器表分页查询", notes = "户用光伏监盘逆变器表分页查询")
	public ResponseModel<Page<JpInverterDto>> queryForPage(@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size, JpInverterDto jpInverterDto) {

        List<JpPersonStation> pPersonStation =null;
        if(jpInverterDto.getName()!=null){
            LambdaQueryWrapper<JpPersonStation> qug1=new LambdaQueryWrapper<>();
            qug1.like(JpPersonStation::getStationName,jpInverterDto.getName());
            pPersonStation=pPersonStationMapper.selectList(qug1);

        }else{
            LambdaQueryWrapper<JpPersonStation> qug = new LambdaQueryWrapper<>();
            qug.eq(JpPersonStation::getPersonId, getUserInfo().getUserId());
             pPersonStation = pPersonStationMapper.selectList(qug);
        }

		if (!pPersonStation.isEmpty()) {
			Page<JpInverterDto> page = new Page<JpInverterDto>();
			page.setCurrent(current);
			page.setSize(size);
			List<String> ids = pPersonStation.stream().map(i -> i.getStationId()).collect(Collectors.toList());
			jpInverterDto.setStationIds(ids);
			return ResponseHelper.buildResponse(jpInverterServiceImpl.queryForJpInverterPage(page, jpInverterDto));
		} else {
			return ResponseHelper.buildResponse(new Page<JpInverterDto>());
		}
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘逆变器表列表全部数据查询", notes = "户用光伏监盘逆变器表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JpInverterDto>> selectForList() {
		return ResponseHelper.buildResponse(jpInverterServiceImpl.queryForJpInverterList());
	}
}
