package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpInvertorElecHistoryAllServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInvertorElecHistoryAllDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 户用光伏监盘逆变器电能历史表
 *
 * @author system_generator
 * @date 2023-09-20
 */
@RestController
@Api(tags = "户用光伏监盘逆变器电能历史表Api")
@RequestMapping(value = "/jp-invertor-elec-history-all")
public class JpInvertorElecHistoryAllController extends BaseController {

    @Autowired
    JpInvertorElecHistoryAllServiceImpl jpInvertorElecHistoryAllServiceImpl;

    /**
     * 新增户用光伏监盘逆变器电能历史表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏监盘逆变器电能历史表", notes = "新增户用光伏监盘逆变器电能历史表")
	public ResponseModel<JpInvertorElecHistoryAllDto> save(@RequestBody JpInvertorElecHistoryAllDto model) {
	    model = jpInvertorElecHistoryAllServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏监盘逆变器电能历史表", notes = "根据sequenceNbr更新户用光伏监盘逆变器电能历史表")
	public ResponseModel<JpInvertorElecHistoryAllDto> updateBySequenceNbrJpInvertorElecHistoryAll(@RequestBody JpInvertorElecHistoryAllDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryAllServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏监盘逆变器电能历史表", notes = "根据sequenceNbr删除户用光伏监盘逆变器电能历史表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jpInvertorElecHistoryAllServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个户用光伏监盘逆变器电能历史表",  notes = "根据sequenceNbr查询单个户用光伏监盘逆变器电能历史表")
	public ResponseModel<JpInvertorElecHistoryAllDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryAllServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "户用光伏监盘逆变器电能历史表分页查询",  notes = "户用光伏监盘逆变器电能历史表分页查询")
	public ResponseModel<Page<JpInvertorElecHistoryAllDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JpInvertorElecHistoryAllDto> page = new Page<JpInvertorElecHistoryAllDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryAllServiceImpl.queryForJpInvertorElecHistoryAllPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "户用光伏监盘逆变器电能历史表列表全部数据查询",   notes = "户用光伏监盘逆变器电能历史表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JpInvertorElecHistoryAllDto>> selectForList() {
	    return ResponseHelper.buildResponse(jpInvertorElecHistoryAllServiceImpl.queryForJpInvertorElecHistoryAllList());
	}
}
