package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.yeejoin.amos.boot.module.hygf.api.entity.JpCollector;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpCollectorMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IJpCollectorService;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpStationDto;

import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 户用光伏监盘采集器表服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class JpCollectorServiceImpl extends BaseService<JpCollectorDto, JpCollector, JpCollectorMapper>
		implements IJpCollectorService {
	/**
	 * 分页查询
	 */
	public Page<JpCollectorDto> queryForJpCollectorPage(Page<JpCollectorDto> page, JpCollectorDto jpCollectorDto) {
		Page<JpCollector> entiryPage = new Page<>(page.getCurrent(), page.getSize());
		LambdaQueryWrapper<JpCollector> wrapper = new LambdaQueryWrapper<>();
		if (jpCollectorDto.getState() != null) {
			wrapper.eq(JpCollector::getState, jpCollectorDto.getState());
		}
		if (!jpCollectorDto.getStationIds().isEmpty()) {
			wrapper.in(JpCollector::getThirdStationId, jpCollectorDto.getStationIds());
		}

        if (!jpCollectorDto.getSnCode().isEmpty()) {
            wrapper.like(JpCollector::getSnCode, jpCollectorDto.getSnCode());
        }

		entiryPage = (Page<JpCollector>) this.page(entiryPage, wrapper);
		if (!ValidationUtil.isEmpty(entiryPage.getRecords())) {
			page.setTotal(entiryPage.getTotal());
			page.setPages(entiryPage.getPages());
			page.setCurrent(entiryPage.getCurrent());
			page.setSize(entiryPage.getSize());

			if (!ValidationUtil.isEmpty(entiryPage.getRecords()))
				page.setRecords(Bean.toModels(entiryPage.getRecords(), this.getModelClass()));
		}
		return page;
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpCollectorDto> queryForJpCollectorList() {
		return this.queryForList("", false);
	}
}