package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpInverterHistoryDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpCollector;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHygfJpInverterHistory;
import com.yeejoin.amos.boot.module.hygf.api.service.ITdHygfJpInverterHistoryService;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.TdHygfJpInverterHistoryMapper;

/**
 * 户用光伏监盘逆变器历史表服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class TdHygfJpInverterHistoryServiceImpl
		extends BaseService<TdHygfJpInverterHistoryDto, TdHygfJpInverterHistory, TdHygfJpInverterHistoryMapper>
		implements ITdHygfJpInverterHistoryService {

	@Autowired
	private JpInverterServiceImpl jpInverterServiceImpl;

	/**
	 * 分页查询
	 */
	public Page<TdHygfJpInverterHistoryDto> queryForTdHygfJpInverterHistoryPage(Page<TdHygfJpInverterHistoryDto> page) {
		return this.queryForPage(page, null, false);
	}

	/**
	 * 列表查询 示例
	 */
	public List<TdHygfJpInverterHistoryDto> queryForTdHygfJpInverterHistoryList() {
		return this.queryForList("", false);
	}

	public Map<String, Object> statistics(String id, String type, String date) {
		JpInverter inverter = jpInverterServiceImpl.getById(id);
		Double power = null, dailyReturn = null, hours = null;
		Map<String, Object> map = new HashMap();
		if (inverter != null) {
			date = "%" + date + "%";
			if ("day".equals(type)) {
				map = this.baseMapper.sum(inverter.getSnCode(), inverter.getThirdStationId(), date);
			} else if ("month".equals(type)) {
				map = this.baseMapper.sum(inverter.getSnCode(), inverter.getThirdStationId(), date);
			} else if ("year".equals(type)) {
				map = this.baseMapper.sum(inverter.getSnCode(), inverter.getThirdStationId(), date);
			} else if ("all".equals(type)) {
				map = this.baseMapper.sum(inverter.getSnCode(), inverter.getThirdStationId(), date);
			}
		}
		if(!map.containsKey("return")) 
		{
			map.put("return", null);
		}
		if (map == null) {
			map = new HashMap();
			map.put("power", power);
			map.put("return", dailyReturn);
			map.put("hours", hours);
		}
		return map;
	}
}