package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanWarningRecordDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanWarningRecord;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanWarningRuleSet;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvWarningRuleSet;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.IdxBizFanWarningRecordServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.IdxBizFanWarningRuleSetServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.IdxBizPvWarningRuleSetServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2.FanWaringRecordMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanWarningRecord;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.BeanMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 *
 * @author system_generator
 * @date 2023-08-15
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/idx-biz-fan-warning-record")
public class IdxBizFanWarningRecordController extends BaseController {

    @Autowired
    IdxBizFanWarningRecordServiceImpl idxBizFanWarningRecordServiceImpl;

    @Autowired
	IdxBizFanWarningRuleSetServiceImpl idxBizFanWarningRuleSetService;

    @Autowired
	IdxBizPvWarningRuleSetServiceImpl idxBizPvWarningRuleSetService;

    @Autowired
	FanWaringRecordMapper fanWaringRecordMapper;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<IdxBizFanWarningRecordDto> save(@RequestBody IdxBizFanWarningRecordDto model) {
	    model = idxBizFanWarningRecordServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<IdxBizFanWarningRecordDto> updateBySequenceNbrIdxBizFanWarningRecord(@RequestBody IdxBizFanWarningRecordDto model,@PathVariable(value = "sequenceNbr") String sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(idxBizFanWarningRecordServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(idxBizFanWarningRecordServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<IdxBizFanWarningRecordDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(idxBizFanWarningRecordServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<IdxBizFanWarningRecordDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<IdxBizFanWarningRecordDto> page = new Page<IdxBizFanWarningRecordDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(idxBizFanWarningRecordServiceImpl.queryForIdxBizFanWarningRecordPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IdxBizFanWarningRecordDto>> selectForList() {
	    return ResponseHelper.buildResponse(idxBizFanWarningRecordServiceImpl.queryForIdxBizFanWarningRecordList());
	}


	/**
	 * 根据sequenceNbr查询
	 *
	 * @param ANALYSISPOINTID  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getInfoByPointId")
	@ApiOperation(httpMethod = "GET",value = "根据ANALYSIS_POINT_ID查询单个",  notes = "根据ANALYSIS_POINT_ID查询单个")
	public ResponseModel<Map<String, Object>> getInfoByPointId(@RequestParam String ANALYSISPOINTID) {

		LambdaQueryWrapper<IdxBizFanWarningRuleSet>	query  =new LambdaQueryWrapper<>();
		query.eq(IdxBizFanWarningRuleSet::getAnalysisPointId,ANALYSISPOINTID);
		List<IdxBizFanWarningRuleSet> idxBizFanWarningRecordList = idxBizFanWarningRuleSetService.getBaseMapper().selectList(query);
		Map<String,Object> map = new HashMap<>();
		for (int i = 0; i < idxBizFanWarningRecordList.size(); i++) {
			IdxBizFanWarningRuleSet idxBizFanWarningRecord = idxBizFanWarningRecordList.get(i);
			if (idxBizFanWarningRecord.getWarningName().equals("注意")){
				map.putAll(BeanUtil.beanToMap(idxBizFanWarningRecord));
			}else if (idxBizFanWarningRecord.getWarningName().equals("警告")){
				//警告周期
				map.put("jgWarningCycle",idxBizFanWarningRecord.getWarningCycle());
				map.put("jgWarningIf",idxBizFanWarningRecord.getWarningIf());
			}else if (idxBizFanWarningRecord.getWarningName().equals("危险")){
				//警告周期
				map.put("wxWarningCycle",idxBizFanWarningRecord.getWarningCycle());
				map.put("wxWarningIf",idxBizFanWarningRecord.getWarningIf());
			}
		}
		return ResponseHelper.buildResponse(map);
	}



	/**
	 * 根据pointId修改信息
	 *
	 * @param analysisInfo  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/updateByPointInfo")
	@ApiOperation(httpMethod = "POST", value = "根据pointId修改信息", notes = "根据pointId修改信息")
	public ResponseModel<Boolean> updateByPointInfo(@RequestBody JSONObject analysisInfo) {
		LambdaQueryWrapper<IdxBizFanWarningRuleSet> query = new LambdaQueryWrapper<>();
		query.eq(IdxBizFanWarningRuleSet::getAnalysisPointId, analysisInfo.get("analysisPointId"));
		List<IdxBizFanWarningRuleSet> idxBizFanWarningRecordList = idxBizFanWarningRuleSetService.getBaseMapper().selectList(query);
		for (IdxBizFanWarningRuleSet idxBizFanWarningRuleSet : idxBizFanWarningRecordList) {
			BeanUtil.copyProperties(analysisInfo, idxBizFanWarningRuleSet, "sequenceNbr", "warningName");
			if (idxBizFanWarningRuleSet.getWarningName().equals("警告")) {
				//警告周期
				idxBizFanWarningRuleSet.setWarningIf(analysisInfo.get("jgWarningIf").toString());
				idxBizFanWarningRuleSet.setWarningCycle(analysisInfo.get("jgWarningCycle").toString());
			} else if (idxBizFanWarningRuleSet.getWarningName().equals("危险")) {
				//警告周期
				idxBizFanWarningRuleSet.setWarningIf(analysisInfo.get("wxWarningIf").toString());
				idxBizFanWarningRuleSet.setWarningCycle(analysisInfo.get("wxWarningCycle").toString());
			}
		}
		boolean b = idxBizFanWarningRuleSetService.updateBatchById(idxBizFanWarningRecordList);
		return ResponseHelper.buildResponse(b);
	}


	/**
	 * 根据sequenceNbr查询
	 *
	 * @param ANALYSISPOINTID  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getInfoByPointIdPv")
	@ApiOperation(httpMethod = "GET",value = "根据ANALYSIS_POINT_ID查询单个",  notes = "根据ANALYSIS_POINT_ID查询单个")
	public ResponseModel<Map<String, Object>> getInfoByPointIdPv(@RequestParam String ANALYSISPOINTID) {

		LambdaQueryWrapper<IdxBizPvWarningRuleSet>	query  =new LambdaQueryWrapper<>();
		query.eq(IdxBizPvWarningRuleSet::getAnalysisPointId,ANALYSISPOINTID);
		List<IdxBizPvWarningRuleSet> idxBizPvWarningRecordList = idxBizPvWarningRuleSetService.getBaseMapper().selectList(query);
		Map<String,Object> map = new HashMap<>();
		for (int i = 0; i < idxBizPvWarningRecordList.size(); i++) {
			IdxBizPvWarningRuleSet idxBizPvWarningRecord = idxBizPvWarningRecordList.get(i);
			if (idxBizPvWarningRecord.getWarningName().equals("注意")){
				map.putAll(BeanUtil.beanToMap(idxBizPvWarningRecord));
			}else if (idxBizPvWarningRecord.getWarningName().equals("警告")){
				//警告周期
				map.put("jgWarningCycle",idxBizPvWarningRecord.getWarningCycle());
				map.put("jgWarningIf",idxBizPvWarningRecord.getWarningIf());
			}else if (idxBizPvWarningRecord.getWarningName().equals("危险")){
				//警告周期
				map.put("wxWarningCycle",idxBizPvWarningRecord.getWarningCycle());
				map.put("wxWarningIf",idxBizPvWarningRecord.getWarningIf());
			}
		}
		return ResponseHelper.buildResponse(map);
	}



	/**
	 * 根据pointId修改信息
	 *
	 * @param analysisInfo  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/updateByPointInfoPv")
	@ApiOperation(httpMethod = "POST", value = "根据pointId修改信息", notes = "根据pointId修改信息")
	public ResponseModel<Boolean> updateByPointInfoPv(@RequestBody JSONObject analysisInfo) {
		LambdaQueryWrapper<IdxBizPvWarningRuleSet> query = new LambdaQueryWrapper<>();
		query.eq(IdxBizPvWarningRuleSet::getAnalysisPointId, analysisInfo.get("analysisPointId"));
		List<IdxBizPvWarningRuleSet> idxBizFanWarningRecordList = idxBizPvWarningRuleSetService.getBaseMapper().selectList(query);
		for (IdxBizPvWarningRuleSet idxBizPvWarningRuleSet : idxBizFanWarningRecordList) {
			BeanUtil.copyProperties(analysisInfo, idxBizPvWarningRuleSet, "sequenceNbr", "warningName");
			if (idxBizPvWarningRuleSet.getWarningName().equals("警告")) {
				//警告周期
				idxBizPvWarningRuleSet.setWarningIf(analysisInfo.get("jgWarningIf").toString());
				idxBizPvWarningRuleSet.setWarningCycle(analysisInfo.get("jgWarningCycle").toString());
			} else if (idxBizPvWarningRuleSet.getWarningName().equals("危险")) {
				//警告周期
				idxBizPvWarningRuleSet.setWarningIf(analysisInfo.get("wxWarningIf").toString());
				idxBizPvWarningRuleSet.setWarningCycle(analysisInfo.get("wxWarningCycle").toString());
			}
		}
		boolean b = idxBizPvWarningRuleSetService.updateBatchById(idxBizFanWarningRecordList);
		return ResponseHelper.buildResponse(b);
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/stringToMap")
	@ApiOperation(httpMethod = "get", value = "字符串转为对象格式", notes = "字符串转为对象格式")
	public ResponseModel<Map<String, Object>> list(@RequestParam("analysisPointIds") String ids) {
		Map<String, Object> data = new HashMap<>();
		data.put("analysisPointIds", ids);
		return ResponseHelper.buildResponse(data);
	}

	/**
	 * 根据pointId修改信息
	 *
	 * @param analysisInfo  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/updateByPointInfoBatchPv")
	@ApiOperation(httpMethod = "POST", value = "根据pointId修改信息", notes = "根据pointId修改信息")
	public ResponseModel<Boolean> updateByPointInfoBatchPv(@RequestBody JSONObject analysisInfo) {
		LambdaQueryWrapper<IdxBizPvWarningRuleSet> query = new LambdaQueryWrapper<>();
		List<String> analysisPointIds = Arrays.asList(analysisInfo.get("analysisPointIds").toString().split(","));
		query.in(IdxBizPvWarningRuleSet::getAnalysisPointId, analysisPointIds);
		List<IdxBizPvWarningRuleSet> idxBizFanWarningRecordList = idxBizPvWarningRuleSetService.getBaseMapper().selectList(query);
		for (IdxBizPvWarningRuleSet idxBizPvWarningRuleSet : idxBizFanWarningRecordList) {
			BeanUtil.copyProperties(analysisInfo, idxBizPvWarningRuleSet, "analysisPointIds");
			if (idxBizPvWarningRuleSet.getWarningName().equals("警告")) {
				//警告周期
				idxBizPvWarningRuleSet.setWarningCycle(analysisInfo.get("jgWarningCycle").toString());
			} else if (idxBizPvWarningRuleSet.getWarningName().equals("危险")) {
				//警告周期
				idxBizPvWarningRuleSet.setWarningCycle(analysisInfo.get("wxWarningCycle").toString());
			}
		}
		boolean b = idxBizPvWarningRuleSetService.updateBatchById(idxBizFanWarningRecordList);
		return ResponseHelper.buildResponse(b);
	}


	/**
	 * 根据pointId修改信息
	 *
	 * @param analysisInfo  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/updateByPointInfoBatchFan")
	@ApiOperation(httpMethod = "POST", value = "根据pointId修改信息", notes = "根据pointId修改信息")
	public ResponseModel<Boolean> updateByPointInfoBatchFan(@RequestBody JSONObject analysisInfo) {
		LambdaQueryWrapper<IdxBizFanWarningRuleSet> query = new LambdaQueryWrapper<>();
		List<String> analysisPointIds = Arrays.asList(analysisInfo.get("analysisPointIds").toString().split(","));
		query.in(IdxBizFanWarningRuleSet::getAnalysisPointId, analysisPointIds);
		List<IdxBizFanWarningRuleSet> idxBizFanWarningRecordList = idxBizFanWarningRuleSetService.getBaseMapper().selectList(query);
		for (IdxBizFanWarningRuleSet idxBizFanWarningRuleSet : idxBizFanWarningRecordList) {
			BeanUtil.copyProperties(analysisInfo, idxBizFanWarningRuleSet, "analysisPointIds");
			if (idxBizFanWarningRuleSet.getWarningName().equals("警告")) {
				//警告周期
				idxBizFanWarningRuleSet.setWarningCycle(analysisInfo.get("jgWarningCycle").toString());
			} else if (idxBizFanWarningRuleSet.getWarningName().equals("危险")) {
				//警告周期
				idxBizFanWarningRuleSet.setWarningCycle(analysisInfo.get("wxWarningCycle").toString());
			}
		}
		boolean b = idxBizFanWarningRuleSetService.updateBatchById(idxBizFanWarningRecordList);
		return ResponseHelper.buildResponse(b);
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/selectFanWarningNum")
	@ApiOperation(httpMethod = "GET", value = "查询各风机预警状况", notes = "查询各风机预警状况")
	public ResponseModel<List<Map<String,Object>>> selectFanWarningNum(@RequestParam String station) {
		List<Map<String, Object>> maps = fanWaringRecordMapper.selectFanWarningNum(station);

		return ResponseHelper.buildResponse(maps);
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/selectEquipWarningTotal")
	@ApiOperation(httpMethod = "GET", value = "预警信息统计富文本", notes = "预警信息统计富文本")
	public ResponseModel<List<Map<String,Object>>> selectEquipWarningTotal(@RequestParam String STATION,@RequestParam String EQUIPMENTNAME) {
		List<Map<String, Object>> maps = fanWaringRecordMapper.selectEquipWarningTotal(STATION,EQUIPMENTNAME);

		return ResponseHelper.buildResponse(maps);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/selectWarningPoint")
	@ApiOperation(httpMethod = "GET", value = "预警监测设备右侧预警重复列表", notes = "预警监测设备右侧预警重复列表")
	public ResponseModel<List<FanWarningRecord>> selectFanWarningNum(@RequestParam String STATION,@RequestParam String EQUIPMENTNAME) {
		List<FanWarningRecord> maps = fanWaringRecordMapper.selectWarningPoint(STATION,EQUIPMENTNAME);

		return ResponseHelper.buildResponse(maps);
	}

}
