package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.FullViewRecallDataDTO;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.FullViewRecallInfoDTO;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanHealthLevel;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvHealthLevel;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IndicatorData;
import com.yeejoin.amos.boot.module.jxiop.biz.kafka.FanConditionVariablesMessage;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanHealthIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanHealthLevelMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizPvHealthLevelMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.IndicatorDataMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.yeejoin.amos.boot.module.jxiop.biz.kafka.Constant.*;

@RestController
@Api(tags = "智能分析")
@RequestMapping(value = "/kafkaAnalyse")
public class KafkaAnalyseController {

    @Autowired
    FanConditionVariablesMessage fanConditionVariablesMessage;

    @Autowired
    RedisUtils redisUtils;


    @Autowired
    IdxBizFanHealthLevelMapper idxBizFanHealthLevelMapper;

    @Autowired
    IdxBizPvHealthLevelMapper idxBizPvHealthLevelMapper;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getFanConditionVariables")
    @ApiOperation(httpMethod = "POST", value = "计算相关性分析 - 风机 - 新", notes = "计算相关性分析 - 风机 - 新")
    public ResponseModel<Object> getFanConditionVariables() {
        if (redisUtils.hasKey(kafkaTopicConsumer)) {
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getFanConditionVariables();
        redisUtils.set(kafkaTopicConsumer, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getPvConditionVariables")
    @ApiOperation(httpMethod = "POST", value = "计算相关性分析 - 光伏 - 新", notes = "计算相关性分析 - 光伏 - 新")
    public ResponseModel<Object> getPvConditionVariables() {
        if (redisUtils.hasKey(kafkaTopicConsumerPv)) {
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getPvConditionVariables();
        redisUtils.set(kafkaTopicConsumerPv, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getFanConditionVariablesGKHF")
    @ApiOperation(httpMethod = "POST", value = "工况划分 - 风电 - 新", notes = "工况划分 - 风电 - 新")
    public ResponseModel<Object> getFanConditionVariablesGKHF() {
        if (redisUtils.hasKey(kafkaTopicConsumerGKHFFan)) {
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getFanConditionVariablesGKHF();
        redisUtils.set(kafkaTopicConsumerGKHFFan, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getPvConditionVariablesPvGKHF")
    @ApiOperation(httpMethod = "POST", value = "工况划分 - 光伏 - 新", notes = "工况划分 - 光伏 - 新")
    public ResponseModel<Object> getPvConditionVariablesPvGKFX() {
        if (redisUtils.hasKey(kafkaTopicConsumerGKHFPv)) {
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getPvConditionVariablesPvGKFX();
        redisUtils.set(kafkaTopicConsumerGKHFPv, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getFanConditionVariablesZXZ")
    @ApiOperation(httpMethod = "POST", value = "中心值 - 风电 - 新", notes = "中心值 - 风电 - 新")
    public ResponseModel<Object> getFanConditionVariablesZXZ() {
        if (redisUtils.hasKey(kafkaTopicConsumerZXZFan)) {
//            redisUtils.del(kafkaTopicConsumerZXZFan);
//            redisUtils.getExpire(kafkaTopicConsumerZXZFan);
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getFanConditionVariablesZXZ();
        redisUtils.set(kafkaTopicConsumerZXZFan, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getPvConditionVariablesZXZ")
    @ApiOperation(httpMethod = "POST", value = "中心值 - 光伏 - 新", notes = "工况划分 - 光伏 - 新")
    public ResponseModel<Object> getPvConditionVariablesZXZ() {
        if (redisUtils.hasKey(kafkaTopicConsumerZXZPv)) {
//            redisUtils.del(kafkaTopicConsumerZXZPv);
            return ResponseHelper.buildResponse("计算中");
        }
        fanConditionVariablesMessage.getPvConditionVariablesZXZ();
        redisUtils.set(kafkaTopicConsumerZXZPv, RequestContext.getTraceId(), 300);
        return ResponseHelper.buildResponse("开始计算");
    }













    @Autowired
    IndicatorDataMapper indicatorDataMapper;

    @Autowired
    IdxBizFanHealthIndexMapper idxBizFanHealthIndexMapper;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/getAddressInfo")
    @ApiOperation(httpMethod = "GET", value = "getAddressInfo", notes = "getAddressInfo")
    public ResponseModel<List<IndicatorData>> getAddressInfo() {

        List<String> addressInfo = idxBizFanHealthIndexMapper.getAddressInfo();
        String join = String.join(",", addressInfo);
        List<IndicatorData> indicatorData = indicatorDataMapper.selectByAddresses(join, "1668801435891929089");
        return ResponseHelper.buildResponse(indicatorData);
    }


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "全景诊断回溯")
    @GetMapping("/getFullViewRecall")
    public ResponseModel<List<FullViewRecallInfoDTO>> getFullViewRecall(@RequestParam(required = false, value = "analysisType") String analysisType) {
        List<Map<String, Object>> stationIndexInfo = idxBizFanHealthIndexMapper.getStationIndexInfoByParam(analysisType);
        Map<String, Double> stationHealthIndexMap = stationIndexInfo.stream().collect(Collectors.toMap(t -> t.get("station").toString(), t -> Double.parseDouble(t.get("healthIndex").toString())));


        List<Map<String, Object>> equipmentIndexInfo = idxBizFanHealthIndexMapper.getEquipmentIndexInfoByParam(analysisType);
        Map<String, Double> equipmentIndexInfoMap = equipmentIndexInfo.stream().collect(Collectors.toMap(t -> t.get("equipmentName").toString(), t -> Double.parseDouble(t.get("healthIndex").toString())));


        List<Map<String, Object>> subSystemIndexInfo = idxBizFanHealthIndexMapper.getSubSystemIndexInfoByParam(analysisType);
        Map<String, Double> subSystemIndexInfoMap = subSystemIndexInfo.stream().collect(Collectors.toMap(t -> t.get("subSystem").toString(), t -> Double.parseDouble(t.get("healthIndex").toString())));


        List<Map<String, Object>> pointNameIndexInfo = idxBizFanHealthIndexMapper.getPointNameIndexInfoByParam(analysisType);
        Map<String, Double> pointNameIndexInfoMap = pointNameIndexInfo.stream().collect(Collectors.toMap(t -> t.get("gatewayIndexAddress").toString(), t -> Double.parseDouble(t.get("healthIndex").toString())));


        List<IdxBizFanHealthLevel> healthLevelInfoList = idxBizFanHealthIndexMapper.getHealthLevelInfoList();

        List<FullViewRecallDataDTO> list = idxBizFanHealthIndexMapper.getFullViewRecall();
        Map<String, Map<String, Map<String, Map<String, Map<String, List<FullViewRecallDataDTO>>>>>> resultMap = list.stream()
                .collect(Collectors.groupingBy(FullViewRecallDataDTO::getArea,
                        Collectors.groupingBy(FullViewRecallDataDTO::getStation,
                                Collectors.groupingBy(FullViewRecallDataDTO::getEquipmentName,
                                        Collectors.groupingBy(FullViewRecallDataDTO::getSubSystem,
                                                Collectors.groupingBy(FullViewRecallDataDTO::getPointName))))));
        int areaInt = 1;
        int pointNameInt = 1;
        int stationInt = 1;
        int equipmentInt = 1;
        int subSystemInt = 1;
        Double healthScoreInfo = idxBizFanHealthIndexMapper.getHealthScoreInfoByParam(null, null, analysisType).doubleValue();


        LambdaQueryWrapper<IdxBizFanHealthLevel> query = new LambdaQueryWrapper<>();
        query.isNull(IdxBizFanHealthLevel::getStatus);
        query.eq(IdxBizFanHealthLevel::getAnalysisObjType, "全域");
        query.lt(IdxBizFanHealthLevel::getGroupLowerLimit, healthScoreInfo);
        query.ge(IdxBizFanHealthLevel::getGroupUpperLimit, healthScoreInfo);
        IdxBizFanHealthLevel idxBizFanHealthLevel = idxBizFanHealthLevelMapper.selectOne(query);

        FullViewRecallInfoDTO allMapDto = new FullViewRecallInfoDTO();
        allMapDto.setKey("0");
        allMapDto.setName("全域设备健康状态指数");
        allMapDto.setScoreRange("");
        allMapDto.setStatus(idxBizFanHealthLevel.getHealthLevel());
        allMapDto.setScore(healthScoreInfo);
        allMapDto.setIsRoot(true);
        allMapDto.setCategory("category");
        allMapDto.setChildren(new ArrayList<>());
        allMapDto.setParentKey("0");

        for (Map.Entry<String, Map<String, Map<String, Map<String, Map<String, List<FullViewRecallDataDTO>>>>>> areaMap : resultMap.entrySet()) {
            Double areaLowScore = null;
            Double areaHighScore = null;

            Double areaHealthScoreInfo = idxBizFanHealthIndexMapper.getHealthScoreInfoByParam(areaMap.getKey(), null, analysisType).doubleValue();

            LambdaQueryWrapper<IdxBizFanHealthLevel> areaQuery = new LambdaQueryWrapper<>();
            areaQuery.isNull(IdxBizFanHealthLevel::getStatus);
            areaQuery.eq(IdxBizFanHealthLevel::getAnalysisObjType, "片区");
            areaQuery.lt(IdxBizFanHealthLevel::getGroupLowerLimit, areaHealthScoreInfo);
            areaQuery.ge(IdxBizFanHealthLevel::getGroupUpperLimit, areaHealthScoreInfo);
            IdxBizFanHealthLevel areaIdxBizFanHealthLevel = idxBizFanHealthLevelMapper.selectOne(areaQuery);

            FullViewRecallInfoDTO areaMapDto = new FullViewRecallInfoDTO();
            areaMapDto.setKey("0-" + areaInt);
            areaMapDto.setName(areaMap.getKey());
            areaMapDto.setStatus(areaIdxBizFanHealthLevel.getHealthLevel());
            areaMapDto.setScore(areaHealthScoreInfo);
            areaMapDto.setParentKey(allMapDto.getKey());
            allMapDto.getChildren().add(areaMapDto);
            areaInt++;
            List<FullViewRecallInfoDTO> areaMapList = new ArrayList<>();
            for (Map.Entry<String, Map<String, Map<String, Map<String, List<FullViewRecallDataDTO>>>>> stationMap : areaMap.getValue().entrySet()) {
                Double stationLowScore = null;
                Double stationHighScore = null;
                if (areaLowScore == null && areaHighScore == null) {
                    areaLowScore = stationHealthIndexMap.getOrDefault(stationMap.getKey(), 100.0);
                    areaHighScore = stationHealthIndexMap.getOrDefault(stationMap.getKey(), 100.0);
                } else {
                    if (stationHealthIndexMap.getOrDefault(stationMap.getKey(), 100.0) < areaLowScore) {
                        areaLowScore = stationHealthIndexMap.getOrDefault(stationMap.getKey(), 100.0);
                    }
                    if (stationHealthIndexMap.getOrDefault(stationMap.getKey(), 100.0) > areaHighScore) {
                        areaHighScore = stationHealthIndexMap.getOrDefault(stationMap.getKey(), 100.0);
                    }
                }

                FullViewRecallInfoDTO stationDto = new FullViewRecallInfoDTO();
                stationDto.setKey(areaMapDto.getKey() + "-" + stationInt);
                stationDto.setName(stationMap.getKey());

                stationDto.setStatus("");
                stationDto.setScore(stationHealthIndexMap.getOrDefault(stationMap.getKey(), 100.0));
                LambdaQueryWrapper<IdxBizFanHealthLevel> stationQuery = new LambdaQueryWrapper<>();
                stationQuery.like(IdxBizFanHealthLevel::getStatus, stationMap.getKey());
                stationQuery.eq(IdxBizFanHealthLevel::getAnalysisObjType, "场站");
                stationQuery.lt(IdxBizFanHealthLevel::getGroupLowerLimit, stationDto.getScore());
                stationQuery.ge(IdxBizFanHealthLevel::getGroupUpperLimit, stationDto.getScore());
                IdxBizFanHealthLevel stationLevel = idxBizFanHealthLevelMapper.selectOne(stationQuery);
                stationDto.setStatus(ObjectUtils.isNotEmpty(stationLevel) ? stationLevel.getHealthLevel() : "");
                if (ObjectUtils.isEmpty(stationLevel)) {
                    LambdaQueryWrapper<IdxBizPvHealthLevel> stationPvQuery = new LambdaQueryWrapper<>();
                    stationPvQuery.like(IdxBizPvHealthLevel::getStatus, stationMap.getKey());
                    stationPvQuery.eq(IdxBizPvHealthLevel::getAnalysisObjType, "场站");
                    stationPvQuery.lt(IdxBizPvHealthLevel::getGroupLowerLimit, stationDto.getScore());
                    stationPvQuery.ge(IdxBizPvHealthLevel::getGroupUpperLimit, stationDto.getScore());
                    IdxBizPvHealthLevel stationPvLevel = idxBizPvHealthLevelMapper.selectOne(stationPvQuery);
                    if (ObjectUtils.isNotEmpty(stationPvLevel)) {
                        stationDto.setStatus(stationPvLevel.getHealthLevel());
                    }
                }
                stationDto.setParentKey(areaMapDto.getKey());
                areaMapDto.getChildren().add(stationDto);
                stationInt++;
                for (Map.Entry<String, Map<String, Map<String, List<FullViewRecallDataDTO>>>> equipmentMap : stationMap.getValue().entrySet()) {


                    if (stationLowScore == null && stationHighScore == null) {
                        stationLowScore = equipmentIndexInfoMap.getOrDefault(equipmentMap.getKey(), 100.0);
                        stationHighScore = equipmentIndexInfoMap.getOrDefault(equipmentMap.getKey(), 100.0);
                    } else {
                        if (equipmentIndexInfoMap.getOrDefault(equipmentMap.getKey(), 100.0) < stationLowScore) {
                            stationLowScore = equipmentIndexInfoMap.getOrDefault(equipmentMap.getKey(), 100.0);
                        }
                        if (equipmentIndexInfoMap.getOrDefault(equipmentMap.getKey(), 100.0) > stationHighScore) {
                            stationHighScore = equipmentIndexInfoMap.getOrDefault(equipmentMap.getKey(), 100.0);
                        }
                    }

                    FullViewRecallInfoDTO equipmentMapDto = new FullViewRecallInfoDTO();
                    equipmentMapDto.setKey(stationDto.getKey() + "-" + equipmentInt);
                    equipmentMapDto.setName(equipmentMap.getKey());
                    equipmentMapDto.setScoreRange("");
                    IdxBizFanHealthLevel levelInfo = getHealthLevelByScore(healthLevelInfoList, stationMap.getKey(), "设备", equipmentIndexInfoMap.getOrDefault(equipmentMap.getKey(), 100.0));
                    equipmentMapDto.setStatus(levelInfo.getHealthLevel());
                    equipmentMapDto.setScore(equipmentIndexInfoMap.getOrDefault(equipmentMap.getKey(), 100.0));
                    equipmentMapDto.setParentKey(stationDto.getKey());
                    stationDto.getChildren().add(equipmentMapDto);
                    equipmentInt++;
                    for (Map.Entry<String, Map<String, List<FullViewRecallDataDTO>>> subSystemMap : equipmentMap.getValue().entrySet()) {
                        FullViewRecallInfoDTO subSystemMapDto = new FullViewRecallInfoDTO();
                        subSystemMapDto.setKey(equipmentMapDto.getKey() + "-" + subSystemInt);
                        subSystemMapDto.setName(subSystemMap.getKey());
                        subSystemMapDto.setScoreRange("");
//                        subSystemMapDto.setStatus(null);

                        IdxBizFanHealthLevel levelInfoZxt = getHealthLevelByScore(healthLevelInfoList, stationMap.getKey(), "子系统", subSystemIndexInfoMap.getOrDefault(subSystemMap.getKey(), 100.0));
                        subSystemMapDto.setStatus(levelInfoZxt.getHealthLevel());

                        subSystemMapDto.setScore(subSystemIndexInfoMap.getOrDefault(subSystemMap.getKey(), 100.0));
                        subSystemMapDto.setParentKey(equipmentMapDto.getKey());
                        equipmentMapDto.getChildren().add(subSystemMapDto);
                        subSystemInt++;
                        for (Map.Entry<String, List<FullViewRecallDataDTO>> pointNameMap : subSystemMap.getValue().entrySet()) {
                            FullViewRecallInfoDTO pointNameMapDto = new FullViewRecallInfoDTO();
                            pointNameMapDto.setKey(subSystemMapDto.getKey() + "-" + pointNameInt);
                            pointNameMapDto.setName(pointNameMap.getKey());

                            FullViewRecallDataDTO fullViewRecallDataDTO = pointNameMap.getValue().get(0);

                            pointNameMapDto.setScoreRange("");

                            IdxBizFanHealthLevel levelInfoBL = getHealthLevelByScore(healthLevelInfoList, stationMap.getKey(), "测点", pointNameIndexInfoMap.getOrDefault(fullViewRecallDataDTO.getStation() + "_" + fullViewRecallDataDTO.getIndexAddress(), 100.0));
                            pointNameMapDto.setStatus(levelInfoBL.getHealthLevel());

                            pointNameMapDto.setScore(pointNameIndexInfoMap.getOrDefault(fullViewRecallDataDTO.getStation() + "_" + fullViewRecallDataDTO.getIndexAddress(), 100.0));
                            pointNameMapDto.setParentKey(subSystemMapDto.getKey());
                            subSystemMapDto.getChildren().add(pointNameMapDto);

                            pointNameInt++;
                        }
                    }
                }
                stationDto.setScoreRange("(最高：" + stationLowScore + "分, 最低：" + stationHighScore + "分)");
            }

            areaMapDto.setScoreRange("(最高：" + areaLowScore + "分, 最低：" + areaHighScore + "分)");
        }
        List<FullViewRecallInfoDTO> resultList = new ArrayList<>();
        resultList.add(allMapDto);
        return ResponseHelper.buildResponse(resultList);
    }


    private IdxBizFanHealthLevel getHealthLevelByScore(List<IdxBizFanHealthLevel> healthLevelInfoList, String station, String type, Double score) {

        IdxBizFanHealthLevel resultDto = new IdxBizFanHealthLevel();

        String stationType = "风电站";
        List<IdxBizFanHealthLevel> collect = healthLevelInfoList.stream().filter(item -> item.getAnalysisObjType().contains(station)).collect(Collectors.toList());
        for (IdxBizFanHealthLevel item : collect) {
            if (item.getAnalysisObjType().contains("子阵")) {
                stationType = "光伏站";
                break;
            }
        }
        for (IdxBizFanHealthLevel item : collect) {
            if (type.equals("设备") && stationType.equals("风电站") && item.getAnalysisObjType().contains(type) && score >= item.getGroupLowerLimit() && score <= item.getGroupUpperLimit()) {
                resultDto = item;
                break;
            }
            if (type.equals("子系统") && stationType.equals("风电站") && item.getAnalysisObjType().contains(type) && score >= item.getGroupLowerLimit() && score <= item.getGroupUpperLimit()) {
                resultDto = item;
                break;
            }
            if (type.equals("测点") && item.getAnalysisObjType().contains(type) && score >= item.getGroupLowerLimit() && score <= item.getGroupUpperLimit()) {
                resultDto = item;
                break;
            }
            if (type.equals("设备") && stationType.equals("光伏站") && item.getAnalysisObjType().contains("子阵") && score >= item.getGroupLowerLimit() && score <= item.getGroupUpperLimit()) {
                resultDto = item;
                break;
            }
            if (type.equals("子系统") && stationType.equals("光伏站") && item.getAnalysisObjType().contains("设备") && score >= item.getGroupLowerLimit() && score <= item.getGroupUpperLimit()) {
                resultDto = item;
                break;
            }
        }
        return resultDto;
    }

}
