package com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.FanHealthIndexDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.PvHealthIndexDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndexDay;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.PvHealthIndex;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

public interface PvHealthIndexMapper extends BaseMapper<PvHealthIndex> {
    @Select("<script>"+
            "SELECT `health_index` AS healthIndex, `health_index` AS `value`, rec_date AS recDate,  analysis_time,station,equipment_name AS equipmentName,  ( CASE HEALTH_LEVEL WHEN '危险' THEN 3 WHEN '警告' THEN 2 WHEN '注意' THEN 1 ELSE 0 END ) AS status" +
            " FROM analysis_data.pv_health_index_data WHERE  analysis_obj_type = #{analysisObjType}  and analysis_type = #{analysisType}" +
            "<if test='endTimeTop!= null'>  and ts &lt;= #{endTimeTop} </if> " +
            "<if test='startTimeTop!= null'>  and  ts &gt;= #{startTimeTop} </if> " +
            "<if test='area!= null '> AND area = #{area} </if> " +
            "<if test='indexAddress!= null '> AND index_address = #{indexAddress} </if> " +
            "<if test='pointName!= null '>AND point_name = #{pointName} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='healthLevel!= null '>AND health_level = #{healthLevel} </if>" +
            "<if test='subarray!= null'>AND subarray = #{subarray} </if> " +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
            "</script>")
    List<PvHealthIndex> selectData (@Param("healthLevel")String healthLevel, @Param("area")String area, @Param("equipmentName")String equipmentName, @Param("subarray")String subarray, @Param("analysisType")String analysisType, @Param("analysisObjType")String analysisObjType, @Param("station")String station, @Param("pointName")String pointName, @Param("indexAddress")String indexAddress, @Param("startTimeTop") String startTimeTop, @Param("endTimeTop")String endTimeTop);

    int saveBatchHealthIndexList(@Param("list") List<PvHealthIndex> list, @Param("tableName") String tableName, @Param("analysisType") String analysisType);

//    int saveBatchHealthIndexLatestInfo(@Param("list") List<PvHealthIndex> list, @Param("tableName") String tableName);

    List<PvHealthIndex> getInfoListByGroupByCdPv(@Param("startTime") String startTime,
                                                 @Param("tableName") String tableName,
                                                 @Param("analysisObjectType") String analysisObjectType);

    List<PvHealthIndex> getInfoListByGroupBySbPv(@Param("startTime") String startTime,
                                                 @Param("tableName") String tableName,
                                                 @Param("analysisObjectType") String analysisObjectType);

    List<PvHealthIndex> getInfoListByGroupByZzPv(@Param("startTime") String startTime,
                                                 @Param("tableName") String tableName,
                                                 @Param("analysisObjectType") String analysisObjectType);

    List<PvHealthIndex> getInfoListByGroupByCzPv(@Param("startTime") String startTime,
                                                 @Param("tableName") String tableName,
                                                 @Param("analysisObjectType") String analysisObjectType);

    List<PvHealthIndex> getInfoListByGroupByQyPv(@Param("startTime") String startTime,
                                                 @Param("tableName") String tableName,
                                                 @Param("analysisObjectType") String analysisObjectType);


    List<PvHealthIndex> getInfoByPage(@Param("dto") PvHealthIndexDto dto);

    Integer getInfoByPageTotal(@Param("dto") PvHealthIndexDto dto);
}
