package com.yeejoin.amos.boot.module.jxiop.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 人员基本信息
 *
 * @author system_generator
 * @date 2023-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "person_account" ,autoResultMap = true)
public class PersonAccount extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
     * 平台user_id
     */
	@TableField("puser_id")
    private String puserId;

    /**
     * 平台账号名称
     */
	@TableField("account_name")
    private String accountName;

    /**
     * 用户角色
     */
	@TableField(value="roles", typeHandler = FastjsonTypeHandler.class)
    private List<String> roles;


    /**
     * 人员信息id
     */
    @TableField("person_id")
    private Long personId;


    /**
     * 应用
     */
    @TableField(value="application", typeHandler = FastjsonTypeHandler.class)
    private List<String> application;

    @TableField("password")
    private String  password;
    @TableField("secondary_password")
    private String  secondaryPassword;
    /**
     * 业务密码
     */
    @TableField("business_password")
    private String  businessPassword;


    /**
     * 生产用户类型
     */
	@TableField("sc_user_type")
    private String scUserType;

    /**
     * 生产用户分类
     */
	@TableField("sc_user_category")
    private String scUserCategory;

    /**
     *所属场站
     */
    @TableField("project_id")
    private Long projectId;

    @TableField("project_name")
    private String projectName;

    /**
     * 部门班组
     */
    @TableField("department_id")
    private Long departmentId;
    @TableField("project_department_name")
    private String projectDepartmentName;

    /**
     * 姓名
     */
    @TableField("name")
    private String name;
    /**
     * 工号
     */
    @TableField("job_number")
    private String jobNumber;

    /**
     * 证件类型(0-身份证)
     */
    @TableField("ID_type")
    private String idType;

    /**
     * 证件编号
     */
    @TableField("ID_number")
    private String idNumber;
    @TableField(exist = false)
    private String phoneNum;

}
