package com.yeejoin.precontrol.common.enums;

/**
 * @Description: 任务人员附件类型
 * @Author: duanwei
 * @Date: 2020/10/29 
 */
public enum TaskPersonFileEnum {

    /**
     * 作业票
     */
    JOBTICKET("作业票","20"),

    /**
     * 普通附件
     */
    FILE("普通附件","21"),
    /**
     * 图片
     */
    IMAGE("图片","22"),
    /**
     * 发布人附件
     */
    CREATEPERSONFILE("发布人附件","99");


    private String label;
    private String value;

    TaskPersonFileEnum(String label, String value) {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String getLabelByValue(Long value) {
        String label = null;
        for (TaskPersonFileEnum type : TaskPersonFileEnum.values()) {
            if (type.getValue().equals(value)) {
                label = type.getLabel();
                break;
            }
        }
        return label;
    }
}
