package com.yeejoin.precontrol.common.fileparser.factory;

import com.yeejoin.precontrol.common.fileparser.product.html.AbstractHtml;
import com.yeejoin.precontrol.common.fileparser.product.html.PdfHtml;
import com.yeejoin.precontrol.common.fileparser.product.pdf.AbstractPdf;
import com.yeejoin.precontrol.common.fileparser.product.pdf.PdfPdf;
import com.yeejoin.precontrol.common.fileparser.product.png.AbstractPng;
import com.yeejoin.precontrol.common.fileparser.product.png.PdfPng;
import com.yeejoin.precontrol.common.fileparser.product.txt.AbstractText;
import com.yeejoin.precontrol.common.fileparser.product.txt.PdfText;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 类描述: pdf文件转换工厂类
 *
 * @author <a href="mailto:Ydm@nationsky.com">Ydm</a>
 * @version 1.0
 * @date 2016年3月7日
 * @since JDK 1.7
 */
@Slf4j
@Component
public class PdfFactory implements AbstractFactory {


    /**
     * 将pdf文档转换为html文件
     *
     * @param fileName   输入文件名
     * @param outPutFile 输出文件路径
     */
    @Override
    public void convert2Html(String fileName, String outPutFile) throws Exception {
        long startTime = System.currentTimeMillis();
        log.info("start convert pdf to Html,out file [" + outPutFile + ".html]......");
        AbstractHtml html = new PdfHtml();
        html.createHtml(fileName, outPutFile);
        log.info("convert success! Generate " + outPutFile + ".html with "
                + (System.currentTimeMillis() - startTime) + " ms.");
    }

    @Override
    public void convert2Png(String fileName, String outPutFile) throws Exception {
        log.info("start convert pdf to png,out file [" + outPutFile + ".html]......");
        long startTime = System.currentTimeMillis();
        AbstractPng png = new PdfPng();
        png.createPng(fileName, outPutFile);
        log.info("将Pdf转换为png文件......ok");
        log.info("convert success! Generate " + outPutFile + " with "
                + (System.currentTimeMillis() - startTime) + " ms.");
    }

    @Override
    public void convert2Text(String fileName, String outPutFile) throws Exception {
        log.info("start convert pdf to txt,out file [" + outPutFile + ".html]......");
        long startTime = System.currentTimeMillis();
        AbstractText text = new PdfText();
        text.createTxt(fileName, outPutFile);
        log.info("将Pdf转换为txt文件......ok");
        log.info("convert success! Generate " + outPutFile + ".txt with "
                + (System.currentTimeMillis() - startTime) + " ms.");
    }

    @Override
    public boolean convert2Pdf(String fileName, String outPutFile) throws Exception {
        log.info("start convert pdf to pdf,out file [" + outPutFile + ".html]......");
        long startTime = System.currentTimeMillis();
        AbstractPdf html = new PdfPdf();
        html.createPdf(fileName, outPutFile);
        log.info("将Pdf转换为pdf文件......ok");
        log.info("convert success! Generate " + outPutFile + ".pdf with "
                + (System.currentTimeMillis() - startTime) + " ms.");
        return false;
    }

}
