package com.yeejoin.precontrol.common.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

/**
 * 惩罚表Vo
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Data
public class RetributionVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 公司id
     */
    @ApiModelProperty(value = "公司id")
    private Long companyId;
    /**
     * 奖励人id
     */
    @ApiModelProperty(value = "奖励人id")
    private Long personId;
    /**
     * 奖励人奖励人姓名
     */
    @ApiModelProperty(value = "奖励人姓名")
    private String userName;
    /**
     * 项目id
     */
    @ApiModelProperty(value = "任务id")
    private Long taskId;
    /**
     * 单号
     */
    @ApiModelProperty(value = "单号")
    private String taskNo;
    /**
     * 任务类型
     */
    @ApiModelProperty(value = "任务类型")
    private String taskType;
    /**
     * 业务类型
     */
    @ApiModelProperty(value = "业务类型")
    private String businessType;
    /**
     * 违章类型
     */
    @ApiModelProperty(value = "违章类型")
    private String nature;
    /**
     * 分包商名称
     */
    @ApiModelProperty(value = "分包商名称")
    private String companyName;
    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String taskName;
    /**
     * 项目名称
     */
    @ApiModelProperty(value = "项目名称")
    private String projectName;
    /**
     * 惩罚金额
     */
    @ApiModelProperty(value = "惩罚金额")
    private BigDecimal money;
    /**
     * 状态（0-未交罚款，1-已交罚款）
     */
    @ApiModelProperty(value = "状态（0-未交罚款，1-已交罚款）")
    private Integer status;
    /**
     * 交罚款日期
     */
    @ApiModelProperty(value = "交罚款日期")
    private Date exchangeDate;

    /**
     * 状态Code
     */
    @ApiModelProperty(value = "任务状态Code")
    private String statusCode;
    /**
     * 状态描述
     */
    @ApiModelProperty(value = "任务状态描述")
    private String statusValue;
    /**
     * 开始日期
     */
    @ApiModelProperty(value = "开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /**
     * 结束日期
     */
    @ApiModelProperty(value = "结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

	@ApiModelProperty(value = "排序")
	private String sort;

	@ApiModelProperty(value = "排序字段名")
	private String sortName;
	
	@ApiModelProperty(value = "排序顺序")
	private String sortOrder;
}
