package com.yeejoin.amos.boot.module.tdc.api.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * @author DELL
 */
@FeignClient(value = "AMOS-IDX", path = "idx")
public interface IdxFeignService {
    
    /**
     * 查询表详情和表字段
     *
     * @param tableId
     * @return
     */
    @RequestMapping(value = "/table/{tableId}", method = RequestMethod.GET)
    ResponseModel<JSONObject> queryByTableId(@PathVariable String tableId);
}
