package com.yeejoin.amos.boot.module.tzs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 监督管理信息表
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MidEquipSupervisionInfoDto", description="监督管理信息表Dto")
public class SuperviseInfoModel extends BaseDto {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "$column.comments")
    private String supervisoryCode;

    @ApiModelProperty(value = "$column.comments")
    private String instanceId;
    @ApiModelProperty(value = "$column.comments")
    private String status;
    @ApiModelProperty(value = "管辖分局组织机构代码")
    private String orgBranchCode;
    @ApiModelProperty(value = "管辖分局名称")
    private String orgBranchName;
    @ApiModelProperty(value = "是否重点监察设备")
    private String keyMonitoringEqu;
    @ApiModelProperty(value = "是否在人口密集区")
    private String denselyPopulatedAreas;
    @ApiModelProperty(value = "是否在重要场所")
    private String importantPlaces;


}
