package com.yeejoin.amos.boot.module.ugp.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * desc 质量问题代码库表
 */

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_ugp_problem_code_lib")
public class ProblemCodeLib extends BaseEntity {
    /**
     * 质量问题产生阶段
     */
    @TableField("gen_stage")
    private String genStage;

    /**
     * 质量问题
     */
    @TableField("content")
    private String content;

    /**
     * 质量问题代码
     */
    @TableField("code")
    private String code;

    /**
     * 监管指标
     */
    @TableField("indicator")
    private String indicator;

    /**
     * 监管指标单位
     */
    @TableField("idx_unit")
    private String idxUnit;

    /**
     * 监管指标类型
     */
    @TableField("idx_type")
    private String idxType;

    /**
     * 监管指标阈值
     */
    @TableField("idx_thresholds")
    private String idxThresholds;

    /**
     * 创建日期
     */
    @TableField(value = "create_date", fill = FieldFill.INSERT)
    private Date createDate;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
}
