package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 故障报修验收记录
 *
 * @author system_generator
 * @date 2021-08-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_failure_verify")
public class FailureVerify extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 验收人
     */
	@TableField("acceptor")
    private String acceptor;

    /**
     * 验收部门
     */
	@TableField("verify_department")
    private String verifyDepartment;

    /**
     * 验收部门的id
     */
	@TableField("verify_department_id")
    private Long verifyDepartmentId;

    /**
     * 审核结果 0：同意 1：拒绝 
     */
	@TableField("verify_result")
    private Integer verifyResult;

    /**
     * 验收时间
     */
	@TableField("verify_time")
    private Date verifyTime;

    /**
     * 验收意见
     */
	@TableField("verify_opinion")
    private String verifyOpinion;

    /**
     * 设备故障报修单id
     */
	@TableField("fault_id")
    private Long faultId;

}
