package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
* 调派资源dto
*
* @author tb
* @date 2021-08-20
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PowerTransferResourceDto", description="调派资源dto")
public class PowerTransferResourceDto extends BaseDto {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "资源名称")
    private String name;

    @ApiModelProperty(value = "资源类型（中队：company，车辆：car，人员：person）")
    private String type;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "图片")
    private String img;

    @ApiModelProperty(value = "联系电话")
    private String tel;

    @ApiModelProperty(value = "负责人")
    private String chargePerson;

    @ApiModelProperty(value = "驾驶员")
    private String driver;

    @ApiModelProperty(value = "车辆状态")
    private String carState;

    @ApiModelProperty(value = "岗位")
    private String post;

    @ApiModelProperty(value = "性别")
    private String gender;
}
