package com.yeejoin.amos.knowledgebase.face.model;

import org.typroject.tyboot.core.foundation.utils.TreeNode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Collection;

/**
 * <p>
 * 知识库文档分类
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class KnowledgeDocCategoryModel extends BaseModel implements TreeNode<KnowledgeDocCategoryModel,Long> {

        /**
         * 分组名称
         */
    private String categoryName;

    private Long parentId;
        /**
         * 机构编号
         */
    private String agencyCode;

    private Collection<KnowledgeDocCategoryModel> children;


    @Override
    public Long getMyParentId() {
        return this.parentId;
    }

    @Override
    public Long getMyId() {
        return this.sequenceNbr;
    }

    @Override
    public Collection<KnowledgeDocCategoryModel> getChildren() {
        return children;
    }

    @Override
    public void setChildren(Collection<KnowledgeDocCategoryModel> children) {
        this.children  = children;
    }

    @Override
    public int compareTo(KnowledgeDocCategoryModel groupModel) {
        return this.getMyId().compareTo(groupModel.getMyId());
    }
}
