package com.yeejoin.amos.maintenance.dao.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * The persistent class for the p_measures database table.
 * 
 */
@Entity
@Table(name="p_measures")
@NamedQuery(name="Measure.findAll", query="SELECT m FROM Measure m")
public class Measure extends BasicEntity {
	private static final long serialVersionUID = 1L;

	/**
	 * 事故类型
	 */
	@Lob
	@Column(name="accident_type")
	private String accidentType;

	/**
	 * 应急处置
	 */
	@Lob
	private String disposal;

	/**
	 * 工程措施
	 */
	@Lob
	private String engineering;

	/**
	 * 是否删除
	 */
	@Column(name="is_del")
	private int isDel;

	/**
	 * 风险等级
	 */
	private String level;

	/**
	 * 管理措施
	 */
	@Lob
	private String management;

	/**
	 * 风险点id
	 */
	@Column(name="point_id")
	private int pointId;

	/**
	 * 个体防护
	 */
	@Lob
	private String protection;

	/**
	 * 风险因素
	 */
	@Lob
	@Column(name="risk_factors")
	private String riskFactors;

	/**
	 * 培训教育
	 */
	@Lob
	private String train;

	/**
	 * 更新用户id
	 */
	@Column(name="update_by")
	private String updateBy;

	/**
	 * 更新时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="update_time")
	private Date updateTime;

	public Measure() {
	}

	public String getAccidentType() {
		return this.accidentType;
	}

	public void setAccidentType(String accidentType) {
		this.accidentType = accidentType;
	}

	public String getDisposal() {
		return this.disposal;
	}

	public void setDisposal(String disposal) {
		this.disposal = disposal;
	}

	public String getEngineering() {
		return this.engineering;
	}

	public void setEngineering(String engineering) {
		this.engineering = engineering;
	}

	public int getIsDel() {
		return this.isDel;
	}

	public void setIsDel(int isDel) {
		this.isDel = isDel;
	}

	public String getLevel() {
		return this.level;
	}

	public void setLevel(String level) {
		this.level = level;
	}

	public String getManagement() {
		return this.management;
	}

	public void setManagement(String management) {
		this.management = management;
	}

	public int getPointId() {
		return this.pointId;
	}

	public void setPointId(int pointId) {
		this.pointId = pointId;
	}

	public String getProtection() {
		return this.protection;
	}

	public void setProtection(String protection) {
		this.protection = protection;
	}

	public String getRiskFactors() {
		return this.riskFactors;
	}

	public void setRiskFactors(String riskFactors) {
		this.riskFactors = riskFactors;
	}

	public String getTrain() {
		return this.train;
	}

	public void setTrain(String train) {
		this.train = train;
	}

	public String getUpdateBy() {
		return this.updateBy;
	}

	public void setUpdateBy(String updateBy) {
		this.updateBy = updateBy;
	}

	public Date getUpdateTime() {
		return this.updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}
}