package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.CommonMapper;
import com.yeejoin.amos.fas.business.feign.RemoteSecurityService;
import com.yeejoin.amos.fas.business.param.PointListParam;
import com.yeejoin.amos.fas.business.service.intfc.ICommonService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

@Service("commonService")
public class CommonService implements ICommonService {

   /* @Autowired
    private IDeptmentDao deptmentDao;
*/
    @Autowired
    private CommonMapper commonMapper;
    
    @Autowired
    private RemoteSecurityService remoteSecurityService;

   /* @Autowired
    private IUserDao userDao;*/

    @Override
    public List<DepartmentModel> getDepartment(String toke,String product,String appKey,String companyId) {
    	
    	List<DepartmentModel> list=remoteSecurityService.getDepartmentTreeByCompanyId(toke, product, appKey, companyId);
        return list;
    }

    @Override
    public Page<HashMap<String, Object>> getPointList(PointListParam params) {
        long total = commonMapper.countPoint(params);
        List<HashMap<String, Object>> content = commonMapper.getPointList(params);
        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, params, total);
        return result;
    }

    @Override
    public Page<HashMap<String, Object>> getPointInputList(PointListParam params) {
        long total = commonMapper.countPointInput(params);
        List<HashMap<String, Object>> content = commonMapper.getPointInputList(params);
        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, params, total);
        return result;
    }

    @Override
    public List<AgencyUserModel> getUsers(String toke,String product,String appKey,String departmentId) {
    	
    	 List<AgencyUserModel>  list=remoteSecurityService.listUserByDepartmentId(toke, product, appKey, departmentId);
        return list;
    }

    @Override
    public List<AgencyUserModel> getAllUser(String toke,String product,String appKey,String orgCode) {
    	
    	 List<AgencyUserModel>  list=remoteSecurityService.listUserByOrgCode(toke, product, appKey,orgCode);
        return list;
    }
}
