package com.yeejoin.amos.supervision.business.service.impl;

import com.yeejoin.amos.boot.module.common.api.excel.DataSources;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.supervision.business.dao.mapper.PointMapper;
import com.yeejoin.amos.supervision.business.feign.DangerFeignClient;
import com.yeejoin.amos.supervision.dao.entity.Point;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
@Service
public class DataSourcesImpl implements DataSources {

    @Autowired
    HttpServletRequest request;
    @Autowired
    DangerFeignClient dangerFeignClient;
    @Autowired
    PointMapper pointMapper;

    @Override
    public String[] selectList(String type, String method) {
        String[] str = {};
        FeignClientResult<List<DictionarieValueModel>> feignClientResult;
        List<DictionarieValueModel> models;
        switch (method) {
            //隐患级别
            case "getDangerLevelData":
                feignClientResult = dangerFeignClient.getDangerLevelData();
                models = feignClientResult.getResult();
                str = models.stream().map(p -> p.getDictDataValue() + "@" + p.getDictCode()).toArray(String[]::new);
                break;
            //治理方式
            case "getReformTypeData":
                feignClientResult = dangerFeignClient.getDangerGovernanceData();
                models = feignClientResult.getResult();
                str = models.stream().map(p -> p.getDictDataValue() + "@" + p.getDictCode()).toArray(String[]::new);
                break;
            //责任单位
            case "getCompanyData":
                Map<String, String> param = getRequestParamMap();
                List<Point> points = pointMapper.getPointByPlanId(param.get("planId"));
                str = points.stream().map(p -> p.getName() + "@" + p.getId()).toArray(String[]::new);
                break;
            default:
                break;
        }
        return str;
    }

    private Map<String, String> getRequestParamMap() {
        Map<String, String[]> parameterMap = request.getParameterMap();
        Map<String, String[]> localMap = new HashMap<>();
        localMap.putAll(parameterMap);
        localMap.remove("current");
        localMap.remove("size");
        Map<String, String> params = new HashMap<>();
        if (!ValidationUtil.isEmpty(localMap)) {
            for (String key : localMap.keySet()) {
                if (!ValidationUtil.isEmpty(localMap.get(key))) {
                    params.put(key, localMap.get(key)[0]);
                }
            }
        }
        return params;
    }
}
