package com.yeejoin.amos.supervision.business.service.impl;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.service.IWorkflowExcuteService;
import com.yeejoin.amos.boot.biz.common.workflow.feign.WorkflowFeignService;
import com.yeejoin.amos.supervision.business.dao.repository.IPlanAuditDao;
import com.yeejoin.amos.supervision.business.dao.repository.IPlanAuditLogDao;
import com.yeejoin.amos.supervision.business.service.intfc.IPlanAuditService;
import com.yeejoin.amos.supervision.dao.entity.PlanAudit;
import com.yeejoin.amos.supervision.dao.entity.PlanAuditLog;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

@Service("planAuditService")
public class PlanAuditServiceImpl implements IPlanAuditService {

    @Autowired
    private IWorkflowExcuteService workflowExcuteService;

    @Autowired
    private IPlanAuditDao planAuditDao;

    @Autowired
    private IPlanAuditLogDao planAuditLogDao;

    @Autowired
    private WorkflowFeignService workflowFeignService;

    @Override
    @Transactional
    public Boolean auditWorkFlow(PlanAuditLog planAuditLog, String condition, ReginParams reginParams) {
        PlanAudit planAudit = planAuditDao.findByPlanId(planAuditLog.getPlanId());
        if (ObjectUtils.isNotEmpty(planAudit)) {
            String instanceId = planAudit.getProcessInstanceId();
            Map<String, Object> taskAuthMap = workflowExcuteService.checkTaskAuthMap(instanceId, reginParams);
            if (taskAuthMap != null && !taskAuthMap.isEmpty()) {
                String taskId = taskAuthMap.get("taskId") == null ? null : taskAuthMap.get("taskId").toString();
                String name = taskAuthMap.get("name") == null ? null : taskAuthMap.get("name").toString();
                String roleName = reginParams.getRole().getRoleName();
                boolean b = workflowExcuteService.CompleteTask(instanceId, condition, reginParams);
                if (b) {
                    ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
                    workflowExcuteService.setTaskAssign(instanceId, personIdentity.getPersonSeq());
                    planAuditLog.setPlanId(planAudit.getPlanId());
                    planAuditLog.setPlanAuditId(planAudit.getId());
                    planAuditLog.setExcuteUserId(personIdentity.getPersonSeq());
                    planAuditLog.setExcuteUserName(personIdentity.getPersonName());
                    planAuditLog.setFlowTaskId(taskId);
                    planAuditLog.setFlowTaskName(name);
                    planAuditLog.setFlowJson(condition);
                    planAuditLog.setRoleName(roleName);
                    planAuditLogDao.save(planAuditLog);
                }
                return b;
            }
        }
        return Boolean.FALSE;
    }

//    @Override
//    @Transactional
//    public Boolean auditWorkFlow(PlanAuditLog planAuditLog, String condition, ReginParams reginParams) {
//        PlanAudit planAudit = planAuditDao.findByPlanId(planAuditLog.getPlanId());
//        Map<String, Object> taskAuthMap = workflowExcuteService.checkTaskAuthMap(instanceId);
//        if (taskAuthMap != null && !taskAuthMap.isEmpty()) {
//            String taskId = taskAuthMap.get("taskId").toString();
//            String name = taskAuthMap.get("name").toString();
//            if (StringUtils.isNotBlank(taskId)) {
//                String roleName = reginParams.getRole().getRoleName();
////                JSONObject taskGroupName = workflowFeignService.getTaskGroupName(taskId);
////                JSONArray taskGroupNameDetail = taskGroupName.getJSONArray("data");
//////                JSONObject taskGroupNameDetail = JSONObject.parseObject(JSONObject.toJSONString(data.get(data.size() - 2)));
////                if (!ObjectUtils.isEmpty(taskGroupNameDetail)) {
////                    String defaultExecutionRoleProcess = taskGroupNameDetail.getJSONObject(0).getString("groupId");
////                }
//                boolean b = workflowExcuteService.CompleteTask(instanceId, condition);
//                if (b) {
//                    ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
//                    workflowExcuteService.setTaskAssign(instanceId, personIdentity.getPersonSeq());
//
//                    if (ObjectUtils.isNotEmpty(planAudit)) {
//                        planAuditLog.setPlanId(planAudit.getPlanId());
//                        planAuditLog.setPlanAuditId(planAudit.getId());
//                        planAuditLog.setExcuteUserId(personIdentity.getPersonSeq());
//                        planAuditLog.setExcuteUserName(personIdentity.getPersonName());
//                        planAuditLog.setFlowTaskId(taskId);
//                        planAuditLog.setFlowTaskName(name);
//                        planAuditLog.setFlowJson(condition);
//                        planAuditLog.setRoleName(roleName);
//                        planAuditLogDao.save(planAuditLog);
//                    }
//                }
//                return b;
//            }
//        }
//        return Boolean.FALSE;
//    }
}
