package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.WechatRelationServiceImpl;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.WechatRelationDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 微信公众号openid与电话号对应关系表
 *
 * @author system_generator
 * @date 2021-09-22
 */
@RestController
@Api(tags = "openId与手机号对应关系API")
@RequestMapping(value = "/wechat-relation")
public class WechatRelationController extends BaseController {

    @Autowired
    WechatRelationServiceImpl wechatRelationServiceImpl;


	@Autowired
	RedisUtils redisUtils;

    /**
     * 新增微信公众号openid与电话号对应关系表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增微信公众号openid与电话号对应关系表", notes = "新增微信公众号openid与电话号对应关系表")
	public ResponseModel<WechatRelationDto> save(@RequestBody WechatRelationDto model) {
		if (ValidationUtil.isEmpty(model.getOpenId())
				|| ValidationUtil.isEmpty(model.getPhone())
				|| ValidationUtil.isEmpty(model.getCode()))
			throw new BadRequest("参数校验失败.");
    	if(!model.getCode().equals(redisUtils.get("tel_code_" + model.getPhone()))) {
			throw new BadRequest("验证码验证失败!");
		}
	    model = wechatRelationServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}



}
