package com.yeejoin.amos.boot.module.ccs.api.service;


import java.text.ParseException;
import java.util.Map;

/**
 * 换流站告警日统计接口类
 *
 * @author system_generator
 * @date 2021-11-09
 */
public interface IFireSignalDayStatisticsService {

    /**
     * 警情信息
     *
     * @return Map<String, Object>
     */
    Map<String, Object> selectForAlarmCount() throws ParseException;

    /**
     * 警情变化趋势
     *
     * @param beginData 开始日期
     * @param endData   接受日期
     * @return Map<String, Object>
     */
    Map<String, Object> selectForAlarmTrend(String beginData, String endData);

    /**
     * 警情类型占比
     * @param beginData 开始日期
     * @param endData 结束日期
     * @return Map<String, Object>
     */
    Map<String, Object> todayAlarmPercent(String beginData, String endData);
}
