package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @description:
 * @author: tw
 * @createDate: 2021/7/14
 * 指挥资源，请求坐标类
 */
@Data
@ApiModel(value = "RequestData", description = "指挥资源，请求坐标类")
public class RequestData {
    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ApiModelProperty(value = "车辆id")
    private String carId;

    //视频匹配规则方便查询 增加第二个经纬度 用来传递 优先级2的坐标
    @ApiModelProperty(value = "经度2")
    private Double longitudeTwo;

    @ApiModelProperty(value = "纬度2")
    private Double latitudeTwo;

    @ApiModelProperty(value = "距离")
    private Double distance;

    @ApiModelProperty(value = "水源资源类型（hydrant:消火栓、crane:消防水鹤、natural:天然水源、pool:消防水池）")
    private String resourceType;

    @ApiModelProperty(value = "队伍类型code")
    private String typeCode;

    @ApiModelProperty(value = "是否只显示24小时内警情")
    private  Boolean whether24=false;
    /*2547 增加灾情事件类型匹配规则 xml中同步增加模糊查询 54-56行 陈召 2021-09-24 开始*/
    @ApiModelProperty(value = "灾情事件类型模糊匹配")
    private String alertType;
    /*2547 增加灾情事件类型匹配规则 xml中同步增加模糊查询 54-56行 陈召 2021-09-24 结束*/
    @ApiModelProperty(value = "灾情地址模糊匹配")
    private String address;

    @ApiModelProperty(value = "灾情状态")
    private Integer status ;

    @ApiModelProperty(value = "灾情ID")
    private Long alertId ;

    @ApiModelProperty(value = "类型code")
    private String alertTypeCode;

    @ApiModelProperty(value = "排序")
    private String orderTime;

    @ApiModelProperty(value = "筛选条件-建筑Id")
    private String buildingId;

    @ApiModelProperty(value = "筛选条件-视频类型")
    private String type;

    @ApiModelProperty(value = "筛选条件-视频编码")
    private String code;

    @ApiModelProperty(value = "筛选条件-视频名称")
    private String equipmentName;

    @ApiModelProperty(value = "筛选条件-所属单位")
    private String bizOrgCode;
}
