package com.yeejoin.equipmanage.common.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 动态表单树形分组字段表
 *
 * @author duanwei
 * @date 2021-03-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "wl_dynamic_form_column", autoResultMap = true)
@ApiModel(value = "DynamicFormColumn对象", description = "动态表单树形分组字段表")
public class DynamicFormColumn extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "字段名")
    private String fieldName;

    @ApiModelProperty(value = "中文名")
    private String fieldLabel;

    @ApiModelProperty(value = "数据类型：文本，数字，枚举,日期")
    private String dataType;

    @ApiModelProperty(value = "字段分组主键")
    private Long groupId;

    @ApiModelProperty(value = "查询策略;全等,模糊,区间")
    private String queryStrategy;

    @ApiModelProperty(value = "不能为空")
    private Boolean notNull;

    @ApiModelProperty(value = "分组类型")
    private String groupType;

    @ApiModelProperty(value = "所属分组编号")
    private String groupCode;

    @ApiModelProperty(value = "配置json")
    @TableField(value = "data_source",typeHandler = JacksonTypeHandler.class )
    private JSONObject dataSource;

    @ApiModelProperty(value = "提示信息")
    private String remark;

    @ApiModelProperty(value = "创建者")
    private Long creatorId;

    @TableField(exist = false)
    private Boolean isDelete = false;

    @ApiModelProperty(value = "是否必须：0-否；1-是；控制是否可勾选掉字段，暂时没用到标准版使用")
    private Boolean isMust;
}
