package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
* 调派资源统计dto
*
* @author tb
* @date 2021-08-20
*/
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@ApiModel(value="ResourceStatisticsDto", description="调派资源统计dto")
public class ResourceStatisticsDto extends BaseDto {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "全部")
    private Integer allCount = 0;

    @ApiModelProperty(value = "到场")
    private Integer arrived = 0;

    @ApiModelProperty(value = "途中")
    private Integer underway = 0;

    public ResourceStatisticsDto(String type, Integer allCount) {
        this.type = type;
        this.allCount = allCount;
        this.arrived = 0;
        this.underway = 0;
    }
}
