package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertFormValueDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertForm;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.mapper.AlertFormValueMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertFormValueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Collections;
import java.util.List;
import java.util.Map;


/**
*  服务实现类
*
* @author tb
* @date 2021-06-17
*/
@Service
public class AlertFormValueServiceImpl extends  BaseService<AlertFormValueDto,AlertFormValue,AlertFormValueMapper>  implements IAlertFormValueService {

	@Autowired
	private AlertFormValueMapper alertFormValueMapper;

	@Autowired
	private AlertFormServiceImpl alertFormService;
	
	public List<AlertFormValueDto> queryByCalledId(Long alertCalledId) {
		return this.queryForList(null, false, alertCalledId);
	}

	public List<AlertFormValueDto> listByCalledId(Long id) {
		return alertFormValueMapper.selectListByCalledId(id);
	}

	/**
	 * 根据动态表单分组类型查询改分组下所有数据实例
	 *
	 * @param groupCode
	 * @return List<Map <String, Object>>
	 */
	public List<Map<String, Object>> listAll(String groupCode, Map<String, String> queryParams) {
		List<AlertForm> columns =
				alertFormService.list(new LambdaQueryWrapper<AlertForm>().eq(AlertForm::getAlertTypeCode, groupCode));
		List<String> fieldCodes = Lists.transform(columns, AlertForm::getFieldCode);
		return this.baseMapper.listAll(fieldCodes, groupCode, queryParams);
	}

	@Override
	public List<AlertFormValue> getzqlist(Long id) {
		//根据灾情获取航空器 
    	QueryWrapper<AlertFormValue> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("alert_called_id", id);
		// 警情动态表单数据
		return this.list(queryWrapper);
	}
}
