/*
Navicat MySQL Data Transfer

Source Server         : 172.16.10.85
Source Server Version : 80018
Source Host           : 172.16.10.85:3306
Source Database       : amos-ccs-biz

Target Server Type    : MYSQL
Target Server Version : 80018
File Encoding         : 65001

Date: 2021-11-12 11:20:29
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for asf_fire_alarm_day_statistics
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_alarm_day_statistics`;
CREATE TABLE `asf_fire_alarm_day_statistics` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `collect_date` date DEFAULT NULL COMMENT '统计日期',
  `equipment_definition_mrid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '装备定义mrid',
  `equipment_definition_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '装备定义名称',
  `alarm_times` int(11) DEFAULT '1' COMMENT '报警次数',
  `alarm_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '告警类型',
  `alarm_type_name` varchar(255) DEFAULT NULL COMMENT '告警类型名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='换流站告警日统计';

-- ----------------------------
-- Records of asf_fire_alarm_day_statistics
-- ----------------------------
INSERT INTO `asf_fire_alarm_day_statistics` VALUES ('1', '101', '复龙换流站', '2021-11-11', '1', null, '2', null, null, '2021-11-10 11:59:25', '2021-11-11 16:22:28');
INSERT INTO `asf_fire_alarm_day_statistics` VALUES ('2', '102', '金华换流站', '2021-11-11', '1', null, '1', null, null, '2021-11-10 11:59:25', '2021-11-11 15:44:31');

-- ----------------------------
-- Table structure for asf_fire_danger_day_statistics
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_danger_day_statistics`;
CREATE TABLE `asf_fire_danger_day_statistics` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `collect_date` date NOT NULL COMMENT '统计日期',
  `danger_times` int(11) DEFAULT '1' COMMENT '报警次数',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='换流站隐患日统计';

-- ----------------------------
-- Records of asf_fire_danger_day_statistics
-- ----------------------------
INSERT INTO `asf_fire_danger_day_statistics` VALUES ('1', '101', '复龙换流站', '2021-11-11', '2', '2021-11-11 17:06:27', '2021-11-11 17:06:27');

-- ----------------------------
-- Table structure for asf_fire_equipment_alarm
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_equipment_alarm`;
CREATE TABLE `asf_fire_equipment_alarm` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `fire_equipment_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `fire_equipment_mrid` varchar(255) DEFAULT '0' COMMENT '消防设备id',
  `iot_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '设备编码',
  `fire_equipment_index_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '指标名称',
  `fire_equipment_index_key` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '指标编码',
  `fire_equipment_index_value` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '报警值',
  `frequency` int(11) NOT NULL DEFAULT '1' COMMENT '发生频次',
  `status` bit(1) NOT NULL DEFAULT b'1' COMMENT '报警状态：1报警0恢复',
  `type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '报警类型:alarm_type_fire（火灾报警）/alarm_type_trouble（故障告警）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `recovery_date` datetime DEFAULT NULL COMMENT '告警恢复时间',
  `confirm_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '确认类型',
  `alam_reason` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '报警原因',
  `resolve_result` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '处理情况',
  `confirm_user` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '确警人员',
  `confirm_user_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '确警人员姓名',
  `confirm_date` datetime DEFAULT NULL COMMENT '确警时间',
  `system_mrids` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '装备所属消防系统code',
  `equipment_definition_mrid` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '装备定义code（冗余字段）',
  `equipment_definition_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '装备定义名称',
  `location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '设备位置',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`),
  KEY `idx_create_date` (`create_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC COMMENT='设备报警信息表';

-- ----------------------------
-- Records of asf_fire_equipment_alarm
-- ----------------------------

-- ----------------------------
-- Table structure for asf_fire_equipment_alarm_log
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_equipment_alarm_log`;
CREATE TABLE `asf_fire_equipment_alarm_log` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点名称',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点编码',
  `fire_equipment_mrid` varchar(255) NOT NULL DEFAULT '0' COMMENT '消防设备id',
  `fire_equipment_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '设备名称',
  `fire_equipment_index_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '指标名称',
  `fire_equipment_index_key` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '指标编码',
  `fire_equipment_index_value` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '报警值',
  `fire_building_mrid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '建筑id（冗余字段）',
  `alarm_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '报警类型:alarm_type_fire（火灾报警）/alarm_type_trouble（故障告警）',
  `alarm_type_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '告警类型名称',
  `confirm_type` varchar(100) DEFAULT NULL COMMENT '确认类型',
  `confirm_type_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '确认类型名称',
  `alarm_reason` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '报警原因',
  `resolve_result` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '处理情况',
  `confirm_state` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '确认状态: 0-未确认 1-已确认',
  `confirm_user_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '确警人员姓名',
  `confirm_date` datetime DEFAULT NULL COMMENT '确警时间',
  `system_mrids` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '装备所属消防系统code（冗余字段）',
  `equipment_definition_mrid` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '装备定义code（冗余字段）',
  `equipment_definition_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '装备定义名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '告警生成时间',
  `location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '设备位置',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`) USING BTREE,
  KEY `idx_create_date` (`create_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='设备报警信息日志表';

-- ----------------------------
-- Records of asf_fire_equipment_alarm_log
-- ----------------------------
INSERT INTO `asf_fire_equipment_alarm_log` VALUES ('1', '换流站1', '101', '101', '感温', '故障', 'FAS_SmokeAlarm_Fault', 'true', '101', 'FIREALARM', '故障告警', null, null, null, null, '0', null, null, null, null, null, '2021-11-09 11:40:28', '极Ⅰ辅控楼-极1辅控楼二层-火灾报警装置_极1辅控楼二层走道N002L01D011烟感火警状态', null, null, '2021-11-10 15:42:21');
INSERT INTO `asf_fire_equipment_alarm_log` VALUES ('2', '换流站1', '101', '101', '感温', '故障', 'FAS_SmokeAlarm_Fault', 'true', '101', 'FIREALARM', '故障告警', null, null, null, null, '1', null, null, null, null, null, '2021-11-10 11:40:28', '极Ⅰ辅控楼-极1辅控楼二层-火灾报警装置_极1辅控楼二层走道N002L01D011烟感火警状态', null, null, '2021-11-10 15:42:21');
INSERT INTO `asf_fire_equipment_alarm_log` VALUES ('3', '换流站1', '101', '101', '感温', '故障', 'FAS_SmokeAlarm_Fault', 'true', '101', 'FIREALARM', '故障告警', null, null, null, null, '0', null, null, null, null, null, '2021-11-10 11:40:28', '极Ⅰ辅控楼-极1辅控楼二层-火灾报警装置_极1辅控楼二层走道N002L01D011烟感火警状态', null, null, '2021-11-10 15:42:21');
INSERT INTO `asf_fire_equipment_alarm_log` VALUES ('4', '换流站1', '101', '101', '感温', '故障', 'FAS_SmokeAlarm_Fault', 'true', '101', 'FIREALARM', '故障告警', null, null, null, null, '0', null, null, null, null, null, '2021-11-10 11:40:28', '主控楼-主控楼一层-火灾报警装置_极2低端阀组辅助设备室N001L01D001烟感火警状态', null, null, '2021-11-10 15:42:22');

-- ----------------------------
-- Table structure for asf_fire_fmea_statistics
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_fmea_statistics`;
CREATE TABLE `asf_fire_fmea_statistics` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `evaluationOid` int(11) DEFAULT NULL COMMENT 'o值(0到10)',
  `evaluationSid` int(11) DEFAULT NULL COMMENT 's值(0到10)',
  `mutiby` int(11) DEFAULT NULL COMMENT 's*o值（冗余）',
  `risk_source_mrid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '风险mrid',
  `risk_source_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '风险名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='发生率/严重度矩阵统计表';

-- ----------------------------
-- Records of asf_fire_fmea_statistics
-- ----------------------------

-- ----------------------------
-- Table structure for asf_fire_latent_danger
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_latent_danger`;
CREATE TABLE `asf_fire_latent_danger` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `danger_mrid` varchar(32) NOT NULL COMMENT '风险点id',
  `danger_name` varchar(255) DEFAULT NULL COMMENT '风险点名称',
  `danger_state` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '隐患状态:隐患状态（1：待评审；2：待治理；3：安措计划中；4：待验证；5：治理完毕；6：已撤销；7：延期治理中；8：延期治理待车间部门审核；9：延期治理待公司审核''',
  `danger_state_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '隐患状态名称',
  `danger_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '隐患类型枚举(1：无码无计划隐患；2：巡检隐患；3：有码无计划隐患；4：随手拍）',
  `danger_type_name` varchar(255) DEFAULT NULL COMMENT '隐患类型名称',
  `danger_level` varchar(20) DEFAULT NULL COMMENT '隐患等级（1：一般隐患；2：重大隐患） ',
  `danger_level_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '隐患等级名称',
  `discovery_date` datetime DEFAULT NULL COMMENT '隐患提交时间',
  `deal_state` tinyint(4) NOT NULL COMMENT '处理状态:1-未完成；2-已完成',
  `deal_date` datetime DEFAULT NULL COMMENT '治理日期',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='隐患信息';

-- ----------------------------
-- Records of asf_fire_latent_danger
-- ----------------------------
INSERT INTO `asf_fire_latent_danger` VALUES ('101', '101', '换流站1', '10101', '隐患1', '1', '待评审', '2', '巡检隐患', '1', '一般隐患', '2021-11-10 11:06:42', '1', null, '2021-11-10 11:06:47', null, null, '2021-11-11 10:08:26');
INSERT INTO `asf_fire_latent_danger` VALUES ('102', '102', '换流站2', '10102', '隐患1', '2', '待治理', '2', '巡检隐患', '1', '一般隐患', '2021-11-09 11:06:42', '1', null, '2021-11-10 11:06:47', null, null, '2021-11-11 17:29:26');
INSERT INTO `asf_fire_latent_danger` VALUES ('103', '101', '换流站1', '10103', '隐患1', '4', '待验证', '2', '巡检隐患', '1', '一般隐患', '2021-11-04 11:06:42', '1', null, '2021-11-10 11:06:47', null, null, '2021-11-11 17:31:36');
INSERT INTO `asf_fire_latent_danger` VALUES ('104', '101', '换流站1', '10104', '隐患1', '5', '治理完毕', '2', '巡检隐患', '1', '一般隐患', '2021-11-09 11:06:42', '1', null, '2021-11-10 11:06:47', null, null, '2021-11-11 17:31:44');
INSERT INTO `asf_fire_latent_danger` VALUES ('105', '101', '换流站1', '10105', '隐患1', '6', '已撤销', '2', '巡检隐患', '1', '一般隐患', '2021-11-08 11:06:42', '1', null, '2021-11-10 11:06:47', null, null, '2021-11-11 17:32:00');
INSERT INTO `asf_fire_latent_danger` VALUES ('106', '101', '换流站1', '10106', '隐患1', '7', '延期治理中', '2', '巡检隐患', '1', '一般隐患', '2021-11-07 11:06:42', '1', null, '2021-11-10 11:06:47', null, null, '2021-11-11 17:32:14');
INSERT INTO `asf_fire_latent_danger` VALUES ('107', '101', '换流站1', '10107', '隐患1', '2', '待治理', '2', '巡检隐患', '1', '一般隐患', '2021-11-06 11:06:42', '1', null, '2021-11-10 11:06:47', null, null, '2021-11-11 17:33:30');
INSERT INTO `asf_fire_latent_danger` VALUES ('108', '101', '换流站1', '10108', '隐患1', '1', '待评审', '2', '巡检隐患', '1', '一般隐患', '2021-11-04 11:06:42', '1', null, '2021-11-10 11:06:47', null, null, '2021-11-11 10:08:53');
INSERT INTO `asf_fire_latent_danger` VALUES ('109', '101', '换流站1', '10109', '隐患1', '1', '待评审', '2', '巡检隐患', '1', '一般隐患', '2021-11-02 11:06:42', '1', null, '2021-11-10 11:06:47', null, null, '2021-11-11 10:08:55');
INSERT INTO `asf_fire_latent_danger` VALUES ('110', '101', '换流站1', '10110', '隐患1', '1', '待评审', '2', '巡检隐患', '1', '一般隐患', '2021-11-01 11:06:42', '1', null, '2021-11-10 11:06:47', null, null, '2021-11-11 10:08:57');
INSERT INTO `asf_fire_latent_danger` VALUES ('111', '101', '换流站1', '10111', '隐患1', '1', '待评审', '2', '巡检隐患', '1', '一般隐患', '2021-11-05 11:06:42', '1', null, '2021-11-10 11:06:47', null, null, '2021-11-11 10:09:01');

-- ----------------------------
-- Table structure for asf_fire_risk_source
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_risk_source`;
CREATE TABLE `asf_fire_risk_source` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '站点名称',
  `mrid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '唯一标识',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '装备名称',
  `parent_mrid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '上级编号id',
  `risk_level_mrid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '风险等级id',
  `risk_level_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '风险等级名称',
  `risk_level_color` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '风险等级颜色',
  `rpni` decimal(10,2) DEFAULT NULL COMMENT 'rpni属性',
  `rpn` decimal(10,2) DEFAULT NULL COMMENT '实时rpn',
  `status` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '状态(正常normal，异常anomaly)',
  `increment` decimal(10,2) DEFAULT NULL COMMENT 'rpn增量',
  `is_region` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC COMMENT='风险点表';

-- ----------------------------
-- Records of asf_fire_risk_source
-- ----------------------------

-- ----------------------------
-- Table structure for asf_fire_rpn_change_log
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_rpn_change_log`;
CREATE TABLE `asf_fire_rpn_change_log` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) DEFAULT NULL COMMENT '站点名称',
  `risk_point_mrid` varchar(255) DEFAULT NULL COMMENT '风险点id',
  `risk_point_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '风险点名称',
  `risk_point_status` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '点状态：normal-正常；anomaly-异常；',
  `level_code` varchar(255) DEFAULT NULL COMMENT '1-1级；2-2级；3-3级；4-4级',
  `level_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '等级名称 ',
  `level_change_type` tinyint(4) DEFAULT NULL COMMENT '安全等级变化类型:0-安全等级下降；1-安全等级不变；2-安全等级上升',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='风险点变化流水';

-- ----------------------------
-- Records of asf_fire_rpn_change_log
-- ----------------------------

-- ----------------------------
-- Table structure for asf_fire_station_info
-- ----------------------------
DROP TABLE IF EXISTS `asf_fire_station_info`;
CREATE TABLE `asf_fire_station_info` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `code` varchar(32) NOT NULL COMMENT '编号',
  `elec_type_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '换流站类型',
  `use_type_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '用途类型',
  `safety_index` decimal(4,1) DEFAULT NULL COMMENT '安全指数',
  `safety_status` tinyint(4) DEFAULT NULL COMMENT '安全状态：1-重大风险、2-较大风险、3-一般风险、4-低风险',
  `safety_status_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '安全状态名称',
  `safety_status_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '状态对应颜色',
  `status` bit(1) NOT NULL DEFAULT b'0' COMMENT '0-启用；1-停用',
  `position` varchar(255) DEFAULT NULL COMMENT '位置描述',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `station_charge_person` varchar(50) DEFAULT NULL COMMENT '换流站负责人',
  `charge_person_phone` varchar(20) DEFAULT NULL COMMENT '负责人联系电话',
  `safety_charge_person` varchar(50) DEFAULT NULL COMMENT '安全负责人',
  `safety_person_phone` varchar(20) DEFAULT NULL COMMENT '安全负责人联系电话',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  `fire_captain_person` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '驻站消防队队长名称',
  `fire_captain_phone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '驻站消防队队长电话',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_code` (`code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='站端信息表';

-- ----------------------------
-- Records of asf_fire_station_info
-- ----------------------------
INSERT INTO `asf_fire_station_info` VALUES ('1', '复龙换流站', '101', '输电', '公用换流变电站', '90.1', '3', '一般风险', 'yellow', '\0', null, '104.414832500', '28.5443453333', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-10 16:15:46', '队长', '177936945612');
INSERT INTO `asf_fire_station_info` VALUES ('10', '中州换流站', '110', '输电', '公用换流变电站', '92.8', '3', '一般风险', 'blue', '\0', null, '113.625351', '34.746303', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-10 15:36:49', '队长', '177936945612');
INSERT INTO `asf_fire_station_info` VALUES ('11', '龙泉换流站', '111', '输电', '公用换流变电站', '90.1', '3', '一般风险', 'yellow', '\0', null, '119.14126', '28.074916', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-10 15:37:42', '队长', '177936945612');
INSERT INTO `asf_fire_station_info` VALUES ('12', '政平换流站', '112', '输电', '公用换流变电站', '90.1', '3', '一般风险', 'yellow', '\0', null, '117.419823', '25.290481', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-10 15:38:14', '队长', '177936945612');
INSERT INTO `asf_fire_station_info` VALUES ('2', '金华换流站', '102', '输电', '公用换流变电站', '30.0', '1', '重大风险', 'red', '\0', null, '119.647265', '29.079195', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-10 15:38:39', '队长', '177936945612');
INSERT INTO `asf_fire_station_info` VALUES ('3', '锦屏换流站', '103', '输电', '公用换流变电站', '85.0', '2', '较大风险', 'orange', '\0', null, '116.042546', '39.878325', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-10 15:39:09', '队长', '177936945612');
INSERT INTO `asf_fire_station_info` VALUES ('4', '苏州换流站', '104', '输电', '公用换流变电站', '96.0', '4', '较低风险', 'blue', '\0', null, '120.585294', '31.299758', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-10 15:39:31', '队长', '177936945612');
INSERT INTO `asf_fire_station_info` VALUES ('5', '灵州换流站', '105', '输电', '公用换流变电站', '90.1', '3', '一般风险', 'blue', '\0', null, '114.990321', '38.516746', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-10 15:39:52', '队长', '177936945612');
INSERT INTO `asf_fire_station_info` VALUES ('6', '绍兴换流站', '106', '输电', '公用换流变电站', '92.3', '3', '一般风险', 'blue', '\0', null, '120.22120', '29.94020', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-12 09:40:44', '队长', '177936945612');
INSERT INTO `asf_fire_station_info` VALUES ('7', '祁连换流站', '107', '输电', '公用换流变电站', '91.6', '3', '一般风险', 'blue', '\0', null, '121.614786', '38.913962', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-10 15:40:35', '队长', '177936945612');
INSERT INTO `asf_fire_station_info` VALUES ('8', '韶山换流站', '108', '输电', '公用换流变电站', '92.8', '3', '一般风险', 'blue', '\0', null, '112.525364', '27.914796', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-10 15:58:02', '队长', '177936945612');
INSERT INTO `asf_fire_station_info` VALUES ('9', '天山换流站', '109', '输电', '公用换流变电站', '92.8', '3', '一般风险', 'blue', '\0', null, '116.111818', '40.003718', '张三风', '17792961611', '姚明', '17792961621', '2021-11-10 10:37:18', '2021-11-10 15:41:25', '队长', '177936945612');

-- ----------------------------
-- Table structure for ast_fire_building
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_building`;
CREATE TABLE `ast_fire_building` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `mrid` varchar(255) DEFAULT NULL COMMENT '消防建筑唯一标识',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `classify` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '建筑类别',
  `floor_number` varchar(32) DEFAULT NULL COMMENT '楼层数量',
  `equipment_number` int(11) DEFAULT NULL COMMENT '包含装备数量',
  `parent_mrid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '父级mrid',
  `tree_mrids` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci COMMENT '树形mrids，包括自己，冗余用于树形查询',
  `type` varchar(20) DEFAULT NULL COMMENT '类型（建筑、楼层、房间）',
  `photo_url` text COMMENT '建筑图片',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `create_date` datetime DEFAULT NULL COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防建筑表';

-- ----------------------------
-- Records of ast_fire_building
-- ----------------------------
INSERT INTO `ast_fire_building` VALUES ('12101', '101', '复龙换流站', '1301', '建筑1', '高层厂房', '5', '1805', '0', '1301', 'building', null, '104.414832500', '28.5443453333', '2021-11-08 10:34:03', '2021-11-11 14:58:25');
INSERT INTO `ast_fire_building` VALUES ('12102', '101', '复龙换流站', '1302', '建筑2', '高层厂房', '6', '1806', '0', '1302', 'building', null, '113.625351', '34.746303', '2021-11-10 10:34:03', '2021-11-11 14:58:29');
INSERT INTO `ast_fire_building` VALUES ('12103', '101', '复龙换流站', '1303', '建筑3', '高层厂房', '7', '1807', '0', '1303', 'building', null, '119.14126', '28.074916', '2021-11-10 10:34:03', '2021-11-11 14:58:33');
INSERT INTO `ast_fire_building` VALUES ('12104', '101', '复龙换流站', '130101', '楼层1', '高层厂房', '0', '1800', '1301', '1301,130101', 'floor', null, '117.419823', '25.290481', '2021-11-05 10:34:03', '2021-11-11 11:14:55');
INSERT INTO `ast_fire_building` VALUES ('12105', '101', '复龙换流站', '130102', '楼层2', '高层厂房', '0', '1800', '1301', '1301,130102', 'floor', null, '119.647265', '29.079195', '2021-11-09 10:34:03', '2021-11-11 11:14:58');
INSERT INTO `ast_fire_building` VALUES ('12106', '101', '复龙换流站', '13010101', '房间1', '高层厂房', '0', '1800', '130101', '1301,130101,13010101', 'room', null, '116.042546', '39.878325', '2021-11-05 10:34:03', '2021-11-11 11:15:01');
INSERT INTO `ast_fire_building` VALUES ('12107', '101', '复龙换流站', '13010201', '房间1', '高层厂房', '0', '1800', '130102', '1301,130102,13010201', 'room', null, '120.585294', '31.299758', '2021-11-01 10:34:03', '2021-11-11 11:15:06');
INSERT INTO `ast_fire_building` VALUES ('12108', '101', '复龙换流站', '130201', '房间1', '高层厂房', '0', '1800', '1302', '1302,130201', 'room', null, '114.990321', '38.516746', '2021-11-04 10:34:03', '2021-11-11 11:15:11');
INSERT INTO `ast_fire_building` VALUES ('12109', '101', '复龙换流站', '130301', '楼层1', '高层厂房', '0', '1800', '1303', '1303,130301', 'floor', null, '120.582886', '30.051549', '2021-11-05 10:34:03', '2021-11-11 11:15:16');
INSERT INTO `ast_fire_building` VALUES ('12110', '101', '复龙换流站', '13030101', '房间1', '高层厂房', '0', '1800', '130301', '1303,130301,13030101', 'room', null, '121.614786', '38.913962', '2021-11-05 10:34:03', '2021-11-11 11:15:19');
INSERT INTO `ast_fire_building` VALUES ('12111', '101', '复龙换流站', '13030102', '房间2', '高层厂房', '0', '1800', '130301', '1303,130301,13030102', 'room', null, '112.525364', '27.914796', '2021-10-28 10:34:03', '2021-11-11 11:15:25');

-- ----------------------------
-- Table structure for ast_fire_equipment
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_equipment`;
CREATE TABLE `ast_fire_equipment` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'id',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '实物id',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备名称',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备编码',
  `category_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备类别名称',
  `category_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备类别编码',
  `img` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备图片',
  `iot_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '设备物联编码',
  `work_area` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '所属区域',
  `build_mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '所在建筑id',
  `fighting_system_mrids` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '所属消防系统ids',
  `position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '位置',
  `in_use_date` datetime DEFAULT NULL COMMENT '使用日期',
  `is_iot` bit(1) DEFAULT b'0' COMMENT '是否为物联设备：0-否；1-是',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `in_use_state` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '使用状态',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `build_name` varchar(255) DEFAULT NULL COMMENT '建筑名称',
  `area_mrid` varchar(255) DEFAULT NULL COMMENT '物理区域id',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防设备资产';

-- ----------------------------
-- Records of ast_fire_equipment
-- ----------------------------

-- ----------------------------
-- Table structure for ast_fire_equipment_info
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_equipment_info`;
CREATE TABLE `ast_fire_equipment_info` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `fire_equipment_mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '消防资产id',
  `field_name` varchar(255) DEFAULT NULL COMMENT '字段名（英文）',
  `field_label` varchar(255) DEFAULT NULL COMMENT '中文名',
  `value` varchar(255) DEFAULT NULL COMMENT '属性值',
  `data_type` varchar(255) DEFAULT NULL COMMENT '数据类型',
  `measure_unit` varchar(255) DEFAULT NULL COMMENT '计量单位',
  `is_must` bit(1) DEFAULT NULL COMMENT '是否必填',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_fire_equipment_mrid` (`fire_equipment_mrid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防资产参数信息';

-- ----------------------------
-- Records of ast_fire_equipment_info
-- ----------------------------

-- ----------------------------
-- Table structure for ast_fire_fighting_system
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_fighting_system`;
CREATE TABLE `ast_fire_fighting_system` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'id',
  `station_name` varchar(255) DEFAULT NULL COMMENT '站点名称',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '资产id',
  `install_date` varchar(255) DEFAULT NULL COMMENT '安装日期',
  `charge_person` varchar(255) DEFAULT NULL COMMENT '负责人',
  `charge_person_phone` varchar(255) DEFAULT NULL COMMENT '负责人电话',
  `construction_unit` varchar(255) DEFAULT NULL COMMENT '施工单位',
  `maintenance_unit` varchar(255) DEFAULT NULL COMMENT '维保单位',
  `first_maintenance_date` datetime DEFAULT NULL COMMENT '首次维保日期',
  `maintenance_frequency` varchar(255) DEFAULT NULL COMMENT '维保频率',
  `maintenance_phone` varchar(255) DEFAULT NULL COMMENT '维保电话',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防系统信息';

-- ----------------------------
-- Records of ast_fire_fighting_system
-- ----------------------------

-- ----------------------------
-- Table structure for ast_fire_vehicle
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_vehicle`;
CREATE TABLE `ast_fire_vehicle` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'id',
  `mrid` varchar(255) DEFAULT NULL COMMENT '消防资产id',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `number` varchar(255) DEFAULT NULL COMMENT '车辆号',
  `type` varchar(255) DEFAULT NULL COMMENT '车辆类别名称',
  `standard` varchar(255) DEFAULT NULL COMMENT '规格型号',
  `manufacturer` varchar(255) DEFAULT NULL COMMENT '厂商',
  `brand` varchar(255) DEFAULT NULL COMMENT '品牌',
  `country` varchar(255) DEFAULT NULL COMMENT '国别',
  `chassis_country` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '底盘国别',
  `chassis_brand` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '底盘品牌',
  `iot_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '物联编码',
  `state` varchar(255) DEFAULT NULL COMMENT '车辆状态',
  `start_state` varchar(255) DEFAULT NULL COMMENT '启动状态',
  `last_start_date` datetime DEFAULT NULL COMMENT '最近启动时间',
  `maintenance_unit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '维保单位',
  `firstmaintenance_date` timestamp NULL DEFAULT NULL COMMENT '首次维保日期',
  `maintenance_frequency` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '维保频率',
  `maintenance_phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '维保电话',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `updatedate` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防车辆信息';

-- ----------------------------
-- Records of ast_fire_vehicle
-- ----------------------------
INSERT INTO `ast_fire_vehicle` VALUES ('108', '10801', '复龙换流站', '101', '车辆1', '陕99999', '泡沫消防车', null, null, null, null, null, null, null, '', '启动', '2021-11-11 11:39:48', null, null, null, null, null, '2021-11-11 11:39:56', null, null, '2021-11-11 11:39:56');
INSERT INTO `ast_fire_vehicle` VALUES ('10801', '10802', '复龙换流站', '101', '车辆2', '陕99999', '泡沫消防车', null, null, null, null, null, null, null, '', '启动', '2021-11-11 11:39:48', null, null, null, null, null, '2021-11-11 11:42:44', null, null, '2021-11-11 11:42:44');
INSERT INTO `ast_fire_vehicle` VALUES ('10803', '10803', '复龙换流站', '101', '车辆3', '陕99999', '泡沫消防车', null, null, null, null, null, null, null, '', '启动', '2021-11-11 11:39:48', null, null, null, null, null, '2021-11-11 11:42:47', null, null, '2021-11-11 11:42:47');
INSERT INTO `ast_fire_vehicle` VALUES ('10804', '10804', '复龙换流站', '101', '车辆4', '陕99999', '泡沫消防车', null, null, null, null, null, null, null, '', '启动', '2021-11-11 11:39:48', null, null, null, null, null, '2021-11-11 11:42:49', null, null, '2021-11-11 11:42:49');
INSERT INTO `ast_fire_vehicle` VALUES ('10805', '10805', '复龙换流站', '101', '车辆5', '陕99999', '泡沫消防车', null, null, null, null, null, null, null, '', '启动', '2021-11-11 11:39:48', null, null, null, null, null, '2021-11-11 11:42:51', null, null, '2021-11-11 11:42:51');
INSERT INTO `ast_fire_vehicle` VALUES ('10806', '10806', '复龙换流站', '101', '车辆6', '陕99999', '泡沫消防车', null, null, null, null, null, null, null, '', '启动', '2021-11-11 11:39:48', null, null, null, null, null, '2021-11-11 11:42:53', null, null, '2021-11-11 11:42:53');
INSERT INTO `ast_fire_vehicle` VALUES ('10807', '10807', '复龙换流站', '101', '车辆7', '陕99999', '泡沫消防车', null, null, null, null, null, null, null, '', '启动', '2021-11-11 11:39:48', null, null, null, null, null, '2021-11-11 11:42:57', null, null, '2021-11-11 11:42:57');
INSERT INTO `ast_fire_vehicle` VALUES ('10808', '10808', '复龙换流站', '101', '车辆8', '陕99999', '泡沫消防车', null, null, null, null, null, null, null, '', '启动', '2021-11-11 11:39:48', null, null, null, null, null, '2021-11-11 11:43:01', null, null, '2021-11-11 11:43:01');
INSERT INTO `ast_fire_vehicle` VALUES ('10809', '10809', '复龙换流站', '101', '车辆9', '陕99999', '泡沫消防车', null, null, null, null, null, null, null, '', '启动', '2021-11-11 11:39:48', null, null, null, null, null, '2021-11-11 11:43:04', null, null, '2021-11-11 11:43:04');
INSERT INTO `ast_fire_vehicle` VALUES ('10810', '10810', '复龙换流站', '101', '车辆10', '陕99999', '泡沫消防车', null, null, null, null, null, null, null, '', '启动', '2021-11-11 11:39:48', null, null, null, null, null, '2021-11-11 11:43:08', null, null, '2021-11-11 11:43:08');
INSERT INTO `ast_fire_vehicle` VALUES ('10811', '10811', '复龙换流站', '101', '车辆1', '陕99999', '泡沫消防车', null, null, null, null, null, null, null, '', '启动', '2021-11-11 11:39:48', null, null, null, null, null, '2021-11-11 11:39:56', null, null, '2021-11-11 11:39:56');

-- ----------------------------
-- Table structure for ast_fire_vehicle_info
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_vehicle_info`;
CREATE TABLE `ast_fire_vehicle_info` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `fire_vehicle_mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '消防资产id',
  `field_name` varchar(255) DEFAULT NULL COMMENT '字段名（英文）',
  `field_label` varchar(255) DEFAULT NULL COMMENT '中文名',
  `value` varchar(255) DEFAULT NULL COMMENT '属性值',
  `data_type` varchar(255) DEFAULT NULL COMMENT '数据类型',
  `measure_unit` varchar(255) DEFAULT NULL COMMENT '计量单位',
  `is_must` bit(1) DEFAULT NULL COMMENT '是否必填',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_fire_vehicle_mrid` (`fire_vehicle_mrid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防资产参数信息';

-- ----------------------------
-- Records of ast_fire_vehicle_info
-- ----------------------------

-- ----------------------------
-- Table structure for ast_fire_video
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_video`;
CREATE TABLE `ast_fire_video` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '唯一标识',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '类型',
  `position` varchar(255) DEFAULT NULL COMMENT '安装位置',
  `photo_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci COMMENT '图片',
  `building_mrid` varchar(255) DEFAULT NULL COMMENT '所在建筑',
  `building_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '所在建筑名称',
  `play_url` varchar(255) DEFAULT NULL COMMENT '视频播放地址',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `create_date` datetime DEFAULT NULL COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防视频表';

-- ----------------------------
-- Records of ast_fire_video
-- ----------------------------
INSERT INTO `ast_fire_video` VALUES ('10901', '101', '复龙换流站', '10901', '摄像头1', '枪机', '墙角', null, '1301', '建筑1', null, null, null, '2021-11-11 11:50:13', '2021-11-11 13:43:37');
INSERT INTO `ast_fire_video` VALUES ('10902', '101', '复龙换流站', '10902', '摄像头2', '枪机', '墙角', null, '1302', '建筑2', null, null, null, '2021-11-12 11:50:13', '2021-11-11 14:44:22');
INSERT INTO `ast_fire_video` VALUES ('10903', '101', '复龙换流站', '10903', '摄像头3', '枪机', '墙角', null, '1303', '建筑3', null, null, null, '2021-11-13 11:50:13', '2021-11-11 14:44:26');
INSERT INTO `ast_fire_video` VALUES ('10904', '101', '复龙换流站', '10904', '摄像头4', '枪机', '墙角', null, '130101', '楼层1', null, null, null, '2021-11-11 11:50:13', '2021-11-11 11:52:26');
INSERT INTO `ast_fire_video` VALUES ('10905', '101', '复龙换流站', '10905', '摄像头5', '枪机', '墙角', null, '130102', '楼层2', null, null, null, '2021-11-11 11:50:13', '2021-11-11 13:43:37');
INSERT INTO `ast_fire_video` VALUES ('10906', '101', '复龙换流站', '10906', '摄像头6', '枪机', '墙角', null, '13010101', '房间1', null, null, null, '2021-11-11 11:50:13', '2021-11-11 13:43:37');
INSERT INTO `ast_fire_video` VALUES ('10907', '101', '复龙换流站', '10907', '摄像头7', '枪机', '墙角', null, '13010201', '房间1', null, null, null, '2021-11-11 11:50:13', '2021-11-11 13:43:37');
INSERT INTO `ast_fire_video` VALUES ('10908', '101', '复龙换流站', '10908', '摄像头8', '枪机', '墙角', null, '130201', '房间1', null, null, null, '2021-11-11 11:50:13', '2021-11-11 13:43:37');
INSERT INTO `ast_fire_video` VALUES ('10909', '101', '复龙换流站', '10909', '摄像头9', '枪机', '墙角', null, '130301', '楼层1', null, null, null, '2021-11-11 11:50:13', '2021-11-11 13:43:20');
INSERT INTO `ast_fire_video` VALUES ('10910', '101', '复龙换流站', '10910', '摄像头10', '枪机', '墙角', null, '13030101', '房间1', null, null, null, '2021-11-11 11:50:13', '2021-11-11 13:43:37');
INSERT INTO `ast_fire_video` VALUES ('10911', '101', '复龙换流站', '10911', '摄像头11', '枪机', '墙角', null, '13030102', '房间2', null, null, null, '2021-11-11 11:50:13', '2021-11-11 13:43:38');

-- ----------------------------
-- Table structure for ast_fire_water
-- ----------------------------
DROP TABLE IF EXISTS `ast_fire_water`;
CREATE TABLE `ast_fire_water` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `station_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '站点编码',
  `station_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '站点名称',
  `mrid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '唯一标识',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `classify` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '水源类别',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '水池类型（消防水池、消防栓、消防水鹤、天然水源）',
  `water_level` varchar(255) DEFAULT NULL COMMENT '水池液位',
  `contant_person` varchar(255) DEFAULT NULL COMMENT '联系人',
  `contant_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL COMMENT '联系电话',
  `photo_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci COMMENT '图片',
  `lng` varchar(20) DEFAULT NULL COMMENT '经度',
  `lat` varchar(20) DEFAULT NULL COMMENT '纬度',
  `create_date` datetime DEFAULT NULL COMMENT '创建日期',
  `syn_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '同步日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_station_code` (`station_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='消防水源表';

-- ----------------------------
-- Records of ast_fire_water
-- ----------------------------
INSERT INTO `ast_fire_water` VALUES ('101', '101', '复龙换流站', '10701', '消防水池1', '高层厂房', '消防水池', '10.2', '苏慧光', '17792961611', null, '104.414832500', '28.5443453333', '2021-11-11 11:26:10', '2021-11-11 11:29:25');
INSERT INTO `ast_fire_water` VALUES ('102', '101', '复龙换流站', '10702', '消防栓1', '高层厂房', '消防栓', '10.2', '苏慧光', '17792961611', null, '113.625351', '34.746303', '2021-11-11 11:26:10', '2021-11-11 11:29:30');
INSERT INTO `ast_fire_water` VALUES ('103', '101', '复龙换流站', '10703', '消防栓2', '高层厂房', '消防栓', '10.2', '苏慧光', '17792961611', null, '119.14126', '28.074916', '2021-11-11 11:26:10', '2021-11-11 11:29:30');
INSERT INTO `ast_fire_water` VALUES ('104', '101', '复龙换流站', '10704', '消防栓3', '高层厂房', '消防栓', '10.2', '苏慧光', '17792961611', null, '117.419823', '25.290481', '2021-11-11 11:26:10', '2021-11-11 11:29:30');
INSERT INTO `ast_fire_water` VALUES ('105', '101', '复龙换流站', '10705', '消防水鹤1', '高层厂房', '消防水鹤', '10.2', '苏慧光', '17792961611', null, '119.647265', '29.079195', '2021-11-11 11:26:10', '2021-11-11 11:29:30');
INSERT INTO `ast_fire_water` VALUES ('106', '101', '复龙换流站', '10706', '消防水鹤2', '高层厂房', '消防水鹤', '10.2', '苏慧光', '17792961611', null, '116.042546', '39.878325', '2021-11-11 11:26:10', '2021-11-11 11:29:31');
INSERT INTO `ast_fire_water` VALUES ('107', '101', '复龙换流站', '10707', '消防水鹤3', '高层厂房', '消防水鹤', '10.2', '苏慧光', '17792961611', null, '120.585294', '31.299758', '2021-11-11 11:26:10', '2021-11-11 11:29:31');
INSERT INTO `ast_fire_water` VALUES ('108', '101', '复龙换流站', '10708', '天然水源1', '高层厂房', '天然水源', '10.2', '苏慧光', '17792961611', null, '114.990321', '38.516746', '2021-11-11 11:26:10', '2021-11-11 11:29:31');
INSERT INTO `ast_fire_water` VALUES ('109', '101', '复龙换流站', '10709', '天然水源2', '高层厂房', '天然水源', '10.2', '苏慧光', '17792961611', null, '120.582886', '30.051549', '2021-11-11 11:26:10', '2021-11-11 11:29:31');
INSERT INTO `ast_fire_water` VALUES ('110', '101', '复龙换流站', '10710', '天然水源3', '高层厂房', '天然水源', '10.2', '苏慧光', '17792961611', null, '121.614786', '38.913962', '2021-11-11 11:26:10', '2021-11-11 11:29:31');
INSERT INTO `ast_fire_water` VALUES ('111', '101', '复龙换流站', '10711', '天然水源4', '高层厂房', '天然水源', '10.2', '苏慧光', '17792961611', null, '112.525364', '27.914796', '2021-11-11 11:26:10', '2021-11-11 11:29:31');

-- ----------------------------
-- Table structure for DATABASECHANGELOG
-- ----------------------------
DROP TABLE IF EXISTS `DATABASECHANGELOG`;
CREATE TABLE `DATABASECHANGELOG` (
  `ID` varchar(255) NOT NULL,
  `AUTHOR` varchar(255) NOT NULL,
  `FILENAME` varchar(255) NOT NULL,
  `DATEEXECUTED` datetime NOT NULL,
  `ORDEREXECUTED` int(11) NOT NULL,
  `EXECTYPE` varchar(10) NOT NULL,
  `MD5SUM` varchar(35) DEFAULT NULL,
  `DESCRIPTION` varchar(255) DEFAULT NULL,
  `COMMENTS` varchar(255) DEFAULT NULL,
  `TAG` varchar(255) DEFAULT NULL,
  `LIQUIBASE` varchar(20) DEFAULT NULL,
  `CONTEXTS` varchar(255) DEFAULT NULL,
  `LABELS` varchar(255) DEFAULT NULL,
  `DEPLOYMENT_ID` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- ----------------------------
-- Records of DATABASECHANGELOG
-- ----------------------------

-- ----------------------------
-- Table structure for DATABASECHANGELOGLOCK
-- ----------------------------
DROP TABLE IF EXISTS `DATABASECHANGELOGLOCK`;
CREATE TABLE `DATABASECHANGELOGLOCK` (
  `ID` int(11) NOT NULL,
  `LOCKED` bit(1) NOT NULL,
  `LOCKGRANTED` datetime DEFAULT NULL,
  `LOCKEDBY` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- ----------------------------
-- Records of DATABASECHANGELOGLOCK
-- ----------------------------
INSERT INTO `DATABASECHANGELOGLOCK` VALUES ('1', '\0', null, null);
SET FOREIGN_KEY_CHECKS=1;
